CREATE TABLE [dbo].[GROUP_ORDER_FACILITY_ETL](
	[ORDER_ID] [int] NULL,
	[FACILITY_UID] [nvarchar](250) NULL,
	[ORDER_TYPE] [nvarchar](3) NULL,
	[SOURCE_ID] [int] NOT NULL,
	[_SSIS_TIMESTAMP] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Temporary table that stores the association between an order and a facility. Used by reports full job. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_ORDER_FACILITY_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_ACT_ID] ON [dbo].[GROUP_ORDER_FACILITY_ETL] 
(
	[ORDER_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_FACILITY_UID] ON [dbo].[GROUP_ORDER_FACILITY_ETL] 
(
	[FACILITY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[GROUP_ORDER_FACILITY_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO