CREATE TABLE [dbo].[GROUP_BED_WARDGROUP_ETL](
	[BED_SOURCE_ID] [nvarchar](250) NULL,
	[WARDGROUP_SOURCE_PK] [int] NULL,
	[SOURCE_ID] INT NOT NULL,
	[COMMENT] [nvarchar](500) NULL,
	[_ssis_timestamp] [datetime] NULL
) ON [PRIMARY]
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Temporary relation between a bed and a ward group table. Used by reports full job.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'GROUP_BED_WARDGROUP_ETL'
GO
CREATE NONCLUSTERED INDEX [idx_BED_SOURCE_ID] ON [dbo].[GROUP_BED_WARDGROUP_ETL] 
(
	[BED_SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_SOURCE_ID] ON [dbo].[GROUP_BED_WARDGROUP_ETL] 
(
	[SOURCE_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [idx_WARDGROUP_SOURCE_PK] ON [dbo].[GROUP_BED_WARDGROUP_ETL] 
(
	[WARDGROUP_SOURCE_PK] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO