IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_ETL_Dim_Icon_Flag_Delete]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[ufn_ETL_Dim_Icon_Flag_Delete]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE function [dbo].[ufn_ETL_Dim_Icon_Flag_Delete](@START_DATE DATETIME, @END_DATE DATETIME)
RETURNS TABLE 
AS
RETURN
(
	SELECT 
      BIF.[ID] as SOURCE_ID
	FROM dbo.BMS_ICON_FLAG AS BIF 
	WHERE  BIF.[_isDeleted] = 1 AND BIF.[_ssis_timestamp] > @START_DATE
			AND BIF.[_ssis_timestamp] < @END_DATE
)
GO


