CREATE TABLE [dbo].[SCHEDULED_ADMISSION](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[PATIENT_UID] [uniqueidentifier] NULL,
	[IEN] [varchar](50) NULL,
	[DOMAIN_ID] [nvarchar](50) NOT NULL,
	[CANCELED_DATE] [datetime] NULL,
	[RESERVATION_DATE] [datetime] NULL,
	[SCHEDULER_UID] [uniqueidentifier] NULL,
	[PROVIDER_UID] [uniqueidentifier] NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[WARD_UID] [uniqueidentifier] NULL,
	[SPECIALITY_ID] [int] NULL,
	[DIAGNOSIS] [nvarchar](max) NULL,
	[SURGERY] [bit] NULL,
	[LENGTH_OF_STAY_EXPECTED] [int] NULL,
	[VISTA_DIVISION_ID] [int] NULL,
	[_ssis_timestamp] [datetime] NULL,
	[CREATEDBY] [nvarchar](50) NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar](50) NULL,
	[UPDATED] [datetime] NULL,
 CONSTRAINT [PK_SCHEDULED_ADMISSION] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO

--Constraints
ALTER TABLE [dbo].[SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_SCHEDULED_ADMISSION_CONCEPT_SPECIALITY] FOREIGN KEY([SPECIALITY_ID])
REFERENCES [dbo].[CONCEPT] ([ID])
GO

ALTER TABLE [dbo].[SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_SCHEDULED_ADMISSION_CONCEPT_SPECIALITY]
GO

ALTER TABLE [dbo].[SCHEDULED_ADMISSION]  WITH CHECK ADD  CONSTRAINT [FK_SCHEDULED_ADMISSION_CONCEPT_VISTA_DIVISION] FOREIGN KEY([VISTA_DIVISION_ID])
REFERENCES [dbo].[CONCEPT] ([ID])
GO

ALTER TABLE [dbo].[SCHEDULED_ADMISSION] CHECK CONSTRAINT [FK_SCHEDULED_ADMISSION_CONCEPT_VISTA_DIVISION]
GO

ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD  CONSTRAINT [DF_SCHEDULED_ADMISSION_SURGERY]  DEFAULT ((0)) FOR [SURGERY]
GO

ALTER TABLE [dbo].[SCHEDULED_ADMISSION] ADD  CONSTRAINT [DF_SCHEDULED_ADMISSION__ssis_timestamp]  DEFAULT (getdate()) FOR [_ssis_timestamp]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_RESERVATION_DATE_VISTA_SITE_UID] ON [dbo].[SCHEDULED_ADMISSION] 
(
	[RESERVATION_DATE] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_IEN_VISTA_SITE_UID] ON [dbo].[SCHEDULED_ADMISSION] 
(
	[IEN] ASC,
	[VISTA_SITE_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[SCHEDULED_ADMISSION] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

--Triggers
create trigger [dbo].[SCHEDULED_ADMISSION_tgg_ssis_delete] on [dbo].[SCHEDULED_ADMISSION] after delete as begin  delete [dbo].[SCHEDULED_ADMISSION_ssisdel] from [deleted] _xyz where [dbo].[SCHEDULED_ADMISSION_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[SCHEDULED_ADMISSION_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
create trigger [dbo].[SCHEDULED_ADMISSION_tgg_ssis_insert] on [dbo].[SCHEDULED_ADMISSION] after insert as begin delete [dbo].[SCHEDULED_ADMISSION_ssisdel]  from [inserted] _xyz where [dbo].[SCHEDULED_ADMISSION_ssisdel].[ID]=[_xyz].[ID] end
GO
CREATE TRIGGER [dbo].[utg_SCHEDULED_ADMISSION_AfterDelete] 
   ON  [dbo].[SCHEDULED_ADMISSION] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
      INSERT INTO $(varBMS_HISTORY).[dbo].[SCHEDULED_ADMISSION_H]
			   (ID, PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, TRANSACTION_TYPE_CODE, [DATE], CREATED_BY)
			SELECT ID, PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 	
END
GO

CREATE TRIGGER [dbo].[utg_SCHEDULED_ADMISSION_AfterInsert] 
   ON  [dbo].[SCHEDULED_ADMISSION] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[SCHEDULED_ADMISSION_H]
			   (ID, PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, TRANSACTION_TYPE_CODE, [DATE], CREATED_BY)
			SELECT ID, PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END
GO

CREATE TRIGGER [dbo].[utg_SCHEDULED_ADMISSION_AfterUpdate] 
   ON  [dbo].[SCHEDULED_ADMISSION] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
	    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[SCHEDULED_ADMISSION_H]
			   (ID, PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, TRANSACTION_TYPE_CODE, [DATE], CREATED_BY)
			SELECT ID, PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO

CREATE TRIGGER [dbo].[utg_SCHEDULED_ADMISSION_InsteadOfInsert] 
   ON  [dbo].[SCHEDULED_ADMISSION]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[SCHEDULED_ADMISSION]
			   (PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, _ssis_timestamp, CREATEDBY, CREATED)
			SELECT PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, _ssis_timestamp, dbo.ufn_Get_BMS_User_Name(), GETUTCDATE()
			  FROM inserted;
	ELSE
		INSERT INTO [dbo].[SCHEDULED_ADMISSION]
			   (PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, _ssis_timestamp)
			SELECT PATIENT_UID, IEN, DOMAIN_ID, CANCELED_DATE, RESERVATION_DATE, SCHEDULER_UID, PROVIDER_UID, VISTA_SITE_UID, WARD_UID, SPECIALITY_ID, DIAGNOSIS, SURGERY, LENGTH_OF_STAY_EXPECTED, VISTA_DIVISION_ID, _ssis_timestamp
			  FROM inserted;
	
END
GO

CREATE TRIGGER [dbo].[utg_SCHEDULED_ADMISSION_InsteadOfUpdate] 
   ON  [dbo].[SCHEDULED_ADMISSION] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
        IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[SCHEDULED_ADMISSION]
		SET PATIENT_UID = inserted.PATIENT_UID,
			IEN = inserted.IEN,
			DOMAIN_ID = inserted.DOMAIN_ID,
			CANCELED_DATE = inserted.CANCELED_DATE,
			RESERVATION_DATE = inserted.RESERVATION_DATE,
			SCHEDULER_UID = inserted.SCHEDULER_UID,
			PROVIDER_UID = inserted.PROVIDER_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			WARD_UID = inserted.WARD_UID,
			SPECIALITY_ID = inserted.SPECIALITY_ID,
			DIAGNOSIS = inserted.DIAGNOSIS,
			SURGERY = inserted.SURGERY,
			LENGTH_OF_STAY_EXPECTED = inserted.LENGTH_OF_STAY_EXPECTED,
			VISTA_DIVISION_ID = inserted.VISTA_DIVISION_ID,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[SCHEDULED_ADMISSION]
		INNER JOIN inserted ON inserted.id = [dbo].[SCHEDULED_ADMISSION].id;
	 ELSE
	    UPDATE [dbo].[SCHEDULED_ADMISSION]
		SET PATIENT_UID = inserted.PATIENT_UID,
			IEN = inserted.IEN,
			DOMAIN_ID = inserted.DOMAIN_ID,
			CANCELED_DATE = inserted.CANCELED_DATE,
			RESERVATION_DATE = inserted.RESERVATION_DATE,
			SCHEDULER_UID = inserted.SCHEDULER_UID,
			PROVIDER_UID = inserted.PROVIDER_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID,
			WARD_UID = inserted.WARD_UID,
			SPECIALITY_ID = inserted.SPECIALITY_ID,
			DIAGNOSIS = inserted.DIAGNOSIS,
			SURGERY = inserted.SURGERY,
			LENGTH_OF_STAY_EXPECTED = inserted.LENGTH_OF_STAY_EXPECTED,
			VISTA_DIVISION_ID = inserted.VISTA_DIVISION_ID,
			_ssis_timestamp = current_timestamp
		FROM [dbo].[SCHEDULED_ADMISSION]
		INNER JOIN inserted ON inserted.id = [dbo].[SCHEDULED_ADMISSION].id;

END
GO