CREATE TABLE [dbo].[SPECIALTY_TRANSFER]
(
	[ID] [int] NOT NULL IDENTITY(1, 1),
	[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[PATIENT_UID] [uniqueidentifier] NULL,
	[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
	[VISTA_SITE_UID] [uniqueidentifier] NULL,
	[DATE_TIME] [datetime] NULL,
	[TYPE_OF_MOVEMENT_ID] [int] NULL,
	[ENTERED_DATE] [datetime] NULL,
	[ENTERED_BY_UID] [uniqueidentifier] NULL,
	[ADMISSION_ID] [int] NULL,
	[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_SPECIALTY_TRANSFER__ssis_timestamp] DEFAULT (getdate()),
	[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
	[UPDATED] [datetime] NULL
)
GO
-- Triggers

CREATE TRIGGER [dbo].[SPECIALTY_TRANSFER_tgg_ssis_delete] on dbo.SPECIALTY_TRANSFER after delete as begin  delete [dbo].[SPECIALTY_TRANSFER_ssisdel] from [deleted] _xyz where [dbo].[SPECIALTY_TRANSFER_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[SPECIALTY_TRANSFER_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
CREATE TRIGGER [dbo].[SPECIALTY_TRANSFER_tgg_ssis_insert] on dbo.SPECIALTY_TRANSFER after insert as begin delete [dbo].[SPECIALTY_TRANSFER_ssisdel]  from [inserted] _xyz where [dbo].[SPECIALTY_TRANSFER_ssisdel].[ID]=[_xyz].[ID] end
GO
CREATE TRIGGER [dbo].[utg_SPECIALTY_TRANSFER_AfterDelete] 
   ON  [dbo].[SPECIALTY_TRANSFER] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[SPECIALTY_TRANSFER_H]
			   (ID, IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
END
GO
CREATE TRIGGER [dbo].[utg_SPECIALTY_TRANSFER_AfterInsert] 
   ON  [dbo].[SPECIALTY_TRANSFER] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[SPECIALTY_TRANSFER_H]
			   (ID, IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO
CREATE TRIGGER [dbo].[utg_SPECIALTY_TRANSFER_AfterUpdate] 
   ON  [dbo].[SPECIALTY_TRANSFER] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[SPECIALTY_TRANSFER_H]
			    (ID, IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
END
GO
CREATE TRIGGER [dbo].[utg_SPECIALTY_TRANSFER_InsteadOfInsert] 
   ON  [dbo].[SPECIALTY_TRANSFER]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[SPECIALTY_TRANSFER]
			   (IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	ELSE
		INSERT INTO [dbo].[SPECIALTY_TRANSFER]
			    (IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp)
			SELECT IEN, PATIENT_UID, DOMAIN_ID, VISTA_SITE_UID, DATE_TIME, TYPE_OF_MOVEMENT_ID, ENTERED_DATE, ENTERED_BY_UID, ADMISSION_ID, _ssis_timestamp
			  FROM inserted;
END
GO
CREATE TRIGGER [dbo].[utg_SPECIALTY_TRANSFER_InsteadOfUpdate] 
   ON  [dbo].[SPECIALTY_TRANSFER] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[SPECIALTY_TRANSFER]
		SET IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			DOMAIN_ID = inserted.DOMAIN_ID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			DATE_TIME = inserted.DATE_TIME, 
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[SPECIALTY_TRANSFER]
			INNER JOIN inserted ON inserted.ID = [dbo].[SPECIALTY_TRANSFER].ID;

	 ELSE
	    UPDATE [dbo].[SPECIALTY_TRANSFER]
		SET IEN = inserted.IEN, 
			PATIENT_UID = inserted.PATIENT_UID, 
			DOMAIN_ID = inserted.DOMAIN_ID, 
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			DATE_TIME = inserted.DATE_TIME, 
			TYPE_OF_MOVEMENT_ID = inserted.TYPE_OF_MOVEMENT_ID, 
			ENTERED_DATE = inserted.ENTERED_DATE, 
			ENTERED_BY_UID = inserted.ENTERED_BY_UID,
			ADMISSION_ID = inserted.ADMISSION_ID, 
			_ssis_timestamp = current_timestamp
		FROM [dbo].[SPECIALTY_TRANSFER]
			INNER JOIN inserted ON inserted.ID = [dbo].[SPECIALTY_TRANSFER].ID;
END
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[SPECIALTY_TRANSFER] ADD CONSTRAINT [PK_SPECIALTY_TRANSFER] PRIMARY KEY CLUSTERED  ([ID])
GO
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[SPECIALTY_TRANSFER] ([_ssis_timestamp])
GO
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_UID_DATE_TIME] ON [dbo].[SPECIALTY_TRANSFER] 
(
       [VISTA_SITE_UID] ASC, [DATE_TIME] ASC
)
INCLUDE ( [ID], [IEN], [PATIENT_UID], [TYPE_OF_MOVEMENT_ID], [ADMISSION_ID])
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX IDX_ADMISSION_ID ON [dbo].[SPECIALTY_TRANSFER] ([ADMISSION_ID])  
GO  
-- Foreign Keys

ALTER TABLE [dbo].[SPECIALTY_TRANSFER] ADD CONSTRAINT [FK_SPECIALTY_TRANSFER_CONCEPT_TYPE_OF_MOVEMENT] FOREIGN KEY ([TYPE_OF_MOVEMENT_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[SPECIALTY_TRANSFER] ADD CONSTRAINT [FK_SPECIALTY_TRANSFER_ADMISSION_EVN_ADMISSION] FOREIGN KEY([ADMISSION_ID]) REFERENCES [dbo].[ADMISSION_EVN] ([ID])
GO

