CREATE TABLE [dbo].[RESOURCE]
(
[ID] [uniqueidentifier] NOT NULL,
[ROOT] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EXTENSION] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Resource_AfterDelete] 
   ON  [dbo].[RESOURCE] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Resource_H]
			   (ID, ROOT, EXTENSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, ROOT, EXTENSION, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Resource_AfterInsert] 
   ON  [dbo].[RESOURCE] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Resource_H]
			   (ID, ROOT, EXTENSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, ROOT, EXTENSION, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
    
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Resource_AfterUpdate] 
   ON  [dbo].[RESOURCE] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    	    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 INSERT INTO $(varBMS_HISTORY).[dbo].[Resource_H]
			   (ID, ROOT, EXTENSION, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, ROOT, EXTENSION, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Resource_InsteadOfInsert] 
   ON  [dbo].[RESOURCE]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Resource]
			   (ID, ROOT, EXTENSION, CREATED, CREATEDBY)
			SELECT ID, ROOT, EXTENSION, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	    
	 
	ELSE
		INSERT INTO [dbo].[Resource]
			   (ID, ROOT, EXTENSION)
			SELECT ID, ROOT, EXTENSION
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Resource_InsteadOfUpdate] 
   ON  [dbo].[RESOURCE] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[Resource]
		SET ROOT = inserted.ROOT,
			EXTENSION = inserted.EXTENSION,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Resource]
		INNER JOIN inserted ON inserted.id = [dbo].[Resource].id;
	  
	 ELSE
	    UPDATE [dbo].[Resource]
		SET ROOT = inserted.ROOT,
			EXTENSION = inserted.EXTENSION
		FROM [dbo].[Resource]
		INNER JOIN inserted ON inserted.id = [dbo].[Resource].id;

END
GO

--Constraints
ALTER TABLE [dbo].[RESOURCE] ADD CONSTRAINT [PK_RESOURCE] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_ROOT_EXTENSION] ON [dbo].[RESOURCE] 
(
	[ROOT] ASC,
	[EXTENSION] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains resources,', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Resource''s extension.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'EXTENSION'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Resource id.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The root of the resource.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'ROOT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'RESOURCE', 'COLUMN', N'UPDATEDBY'
GO
