CREATE TABLE [dbo].[DIVERSION]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[FACILITY_UID] [uniqueidentifier] NOT NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[ACTIVE] [bit] NOT NULL,
[START_DATE] [datetime] NOT NULL,
[END_DATE] [datetime] NOT NULL,
[LOCATION_ID] [int] NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[COMMENTS] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[ENTERED_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ENTERED_DATE] [datetime] NOT NULL,
[LAST_EDIT_BY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Diversion_AfterDelete] 
   ON  [dbo].[DIVERSION] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[DIVERSION_H]
			    (ID, FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Diversion_AfterInsert] 
   ON  [dbo].[DIVERSION] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50), @SQL NVARCHAR(MAX)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
      BEGIN
      INSERT INTO $(varBMS_HISTORY).[dbo].[DIVERSION_H]
								(ID, FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, TRANSACTION_TYPE_CODE, DATE, CREATED_BY) 
		SELECT ID, FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
						 FROM inserted;
						 
	  END		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Diversion_AfterUpdate] 
   ON  [dbo].[DIVERSION] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 INSERT INTO $(varBMS_HISTORY).[dbo].[DIVERSION_H]
			    (ID, FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Diversion_InsteadOfInsert] 
   ON  [dbo].[DIVERSION]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[Diversion]
			    (FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, CREATED, CREATEDBY)
			SELECT FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	ELSE
		INSERT INTO [dbo].[Diversion]
			    (FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY)
			SELECT FACILITY_UID, VISTA_SITE_UID, ACTIVE, START_DATE, END_DATE, LOCATION_ID, DOMAIN_ID, COMMENTS, ENTERED_BY, ENTERED_DATE, LAST_EDIT_BY
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Diversion_InsteadOfUpdate] 
   ON  [dbo].[DIVERSION] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Diversion]
		SET  FACILITY_UID = inserted.FACILITY_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			ACTIVE = inserted.ACTIVE,
			START_DATE = inserted.START_DATE,
			END_DATE = inserted.END_DATE,
			LOCATION_ID = inserted.LOCATION_ID,
			DOMAIN_ID = inserted.DOMAIN_ID,
			COMMENTS = inserted.COMMENTS,
			ENTERED_BY = inserted.ENTERED_BY,
			ENTERED_DATE = inserted.ENTERED_DATE,
			LAST_EDIT_BY = inserted.LAST_EDIT_BY,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Diversion]
		INNER JOIN inserted ON inserted.id = [dbo].[Diversion].id;
	 ELSE
	    UPDATE [dbo].[Diversion]
		SET FACILITY_UID = inserted.FACILITY_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			ACTIVE = inserted.ACTIVE,
			START_DATE = inserted.START_DATE,
			END_DATE = inserted.END_DATE,
			LOCATION_ID = inserted.LOCATION_ID,
			DOMAIN_ID = inserted.DOMAIN_ID,
			COMMENTS = inserted.COMMENTS,
			ENTERED_BY = inserted.ENTERED_BY,
			ENTERED_DATE = inserted.ENTERED_DATE,
			LAST_EDIT_BY = inserted.LAST_EDIT_BY
		FROM [dbo].[Diversion]
		INNER JOIN inserted ON inserted.id = [dbo].[Diversion].id;

END
GO

--Constraints
ALTER TABLE [dbo].[DIVERSION] ADD CONSTRAINT [PK_DIVERSION] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[DIVERSION] ADD CONSTRAINT [FK_DIVERSION_CONCEPT_LOCATION] FOREIGN KEY ([LOCATION_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_FACILITY_UID_LOCATION_ID] ON [dbo].[DIVERSION] 
(
	[FACILITY_UID] ASC,
	[LOCATION_ID] ASC
)
INCLUDE ( [ACTIVE],
[START_DATE],
[END_DATE],
[DOMAIN_ID],
[COMMENTS],
[ENTERED_BY],
[ENTERED_DATE],
[LAST_EDIT_BY]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Table storing information about diversion.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Wheter the diversion is active (current) or not.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'ACTIVE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Additional diversion comments will be stored here.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'COMMENTS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The id of the diversion''s domain.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Till what date the diversion is valid.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'END_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The user name of the BMS application user who entered a diversion.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'ENTERED_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'DateTime when BMS user enters a diversion.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'ENTERED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Which facility this diversion applies to.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'FACILITY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Identity number and primary key of the table.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The user name of the BMS application who changed a diversion.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'LAST_EDIT_BY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The location to which the diversion applies.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'LOCATION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Start date the diversion is valid.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'START_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'DIVERSION', 'COLUMN', N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista site id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'DIVERSION', @level2type=N'COLUMN',@level2name=N'VISTA_SITE_UID'
GO