-- Columns 
CREATE TABLE [dbo].[ORDER_FACILITY]
(
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[ORDER_ID] [int] NULL,
	[FACILITY_UID] [uniqueidentifier] NULL,
	[ORDER_TYPE] [nvarchar](3) NULL,
	[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_ORDER_FACILITY__ssis_timestamp] DEFAULT (getdate()),
	[CREATEDBY] [nvarchar](50) NULL,
	[CREATED] [datetime] NULL,
	[UPDATEDBY] [nvarchar](50) NULL,
	[UPDATED] [datetime] NULL,
)
GO
-- Triggers

CREATE trigger [dbo].[ORDER_FACILITY_tgg_ssis_delete] on dbo.ORDER_FACILITY after delete as begin  delete [dbo].[ORDER_FACILITY_ssisdel] from [deleted] _xyz where [dbo].[ORDER_FACILITY_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[ORDER_FACILITY_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
CREATE trigger [dbo].[ORDER_FACILITY_tgg_ssis_insert] on dbo.ORDER_FACILITY after insert as begin delete [dbo].[ORDER_FACILITY_ssisdel]  from [inserted] _xyz where [dbo].[ORDER_FACILITY_ssisdel].[ID]=[_xyz].[ID] end
GO
CREATE TRIGGER [dbo].[utg_Order_Facility_AfterDelete] 
   ON  [dbo].[ORDER_FACILITY] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     BEGIN 
		INSERT INTO $(varBMS_HISTORY).[dbo].[ORDER_FACILITY_H]
				(ID, ORDER_ID, FACILITY_UID, ORDER_TYPE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT	 ID, ORDER_ID, FACILITY_UID, ORDER_TYPE, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 END		
END
GO
CREATE TRIGGER [dbo].[utg_Order_Facility_AfterInsert] 
   ON  [dbo].[ORDER_FACILITY] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[ORDER_FACILITY_H]
			   (ID, ORDER_ID, FACILITY_UID, ORDER_TYPE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT  ID, ORDER_ID, FACILITY_UID, ORDER_TYPE, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;


END
GO
CREATE TRIGGER [dbo].[utg_Order_Facility_AfterUpdate] 
   ON  [dbo].[ORDER_FACILITY] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[ORDER_FACILITY_H]
				(ID, ORDER_ID, FACILITY_UID, ORDER_TYPE, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
		SELECT   ID, ORDER_ID, FACILITY_UID, ORDER_TYPE, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;

END
GO

CREATE TRIGGER [dbo].[utg_Order_Facility_InsteadOfInsert] 
	   ON  [dbo].[ORDER_FACILITY]
	   INSTEAD OF INSERT
	AS 
	BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		DECLARE @AUDIT_VALUE NVARCHAR(50)

		SELECT @AUDIT_VALUE=PARAMETER_VALUE
		FROM dbo.Options
		WHERE PARAMETER = 'AUDIT';

		IF (UPPER(@AUDIT_VALUE) = 'Y')
			INSERT INTO [dbo].[ORDER_FACILITY]
					(ORDER_ID, FACILITY_UID, ORDER_TYPE, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT   ORDER_ID, FACILITY_UID, ORDER_TYPE, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
				FROM inserted;			
		ELSE
			INSERT INTO [dbo].[ORDER_FACILITY]
					(ORDER_ID, FACILITY_UID, ORDER_TYPE, _ssis_timestamp)
			SELECT   ORDER_ID, FACILITY_UID, ORDER_TYPE, _ssis_timestamp
				FROM inserted;
	END
GO

CREATE TRIGGER [dbo].[utg_Order_Facility_InsteadOfUpdate] 
   ON  [dbo].[ORDER_FACILITY] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
 		UPDATE [dbo].[ORDER_FACILITY]
			SET ORDER_ID = inserted.ORDER_ID, 
				FACILITY_UID = inserted.FACILITY_UID,
				ORDER_TYPE = inserted.ORDER_TYPE,
				_ssis_timestamp = current_timestamp,
				UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
				UPDATED = GETUTCDATE()
			FROM [dbo].[ORDER_FACILITY]
				INNER JOIN inserted ON inserted.ID = [dbo].[ORDER_FACILITY].ID;	
	ELSE
		UPDATE [dbo].[ORDER_FACILITY]
			SET ORDER_ID = inserted.ORDER_ID, 
				FACILITY_UID = inserted.FACILITY_UID,
				ORDER_TYPE = inserted.ORDER_TYPE,
				_ssis_timestamp = current_timestamp
			FROM [dbo].[ORDER_FACILITY]
				INNER JOIN inserted ON inserted.ID = [dbo].[ORDER_FACILITY].ID;

END
GO

-- Constraints
ALTER TABLE [dbo].[ORDER_FACILITY] ADD CONSTRAINT [PK_ORDER_FACILITY] PRIMARY KEY CLUSTERED  ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_ORDER_ID_FACILITY_UID] ON [dbo].[ORDER_FACILITY] 
(
	[ORDER_ID] ASC,
	[FACILITY_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_ORDER_ID_FACILITY_UID_ORDER_TYPE] ON [dbo].[ORDER_FACILITY] 
(
	[ORDER_ID] ASC,
	[FACILITY_UID] ASC,
	[ORDER_TYPE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[ORDER_FACILITY] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_FACILITY_UID_ORDER_TYPE]
ON [dbo].[ORDER_FACILITY] ([FACILITY_UID],[ORDER_TYPE])
INCLUDE ([ORDER_ID])
GO

--Entended properties
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Identity primary key column.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The order id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'ORDER_ID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The facility id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'FACILITY_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record has been inserted.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores the association between an order and a facility. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who created the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'CREATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date and time when the record was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'CREATED'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The User ID of the user who updated the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'UPDATEDBY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Order type (admission, transfer, movement.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ORDER_FACILITY', @level2type=N'COLUMN',@level2name=N'ORDER_TYPE'
GO