CREATE TABLE [dbo].[WAITING_LIST]
(
[ACT_ID] [int] NOT NULL,
[FACILITY_UID] [uniqueidentifier] NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[WAITING_AREA_ID] [int] NULL,
[PROBLEM] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[FEE_DISPOSITION_ID] [int] NULL,
[CONTRACT_FEE_ID] [int] NULL,
[AUTHORIZED_FEE_ID] [int] NULL,
[SERVICE_RECEIVING_FEE_ID] [int] NULL,
[REASON_USING_FEE_ID] [int] NULL,
[FEE_COMMENTS] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REMOVED_DATE] [datetime] NULL,
[TYPE_OF_BED_WARD] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[REQUESTED_BED_UID] [uniqueidentifier] NULL,
[REQUESTED_BED_DATE] [datetime] NULL,
[REQUESTED_DATE] [datetime] NULL,
[IS_IN_HOUSE] [bit] NULL,
[COMMENTS] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[IS_BED_IN_ISOLATION] [bit] NOT NULL,
[LAST_EDIT_BY] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF_WAITING_LIST__ssis_timestamp] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[WAIT_TIME_ALERT_DATE] [datetime] NULL,
[IS_COMMUNITY_LIVING_CENTER] BIT NULL,
[IS_EVACUATION_PATIENT] BIT NULL,
[EVACUATION_DISPOSITION_STATUS_ID] INT NULL,
[EVACUATION_EXPECTED_DATE] DATETIME NULL,
[EVACUATION_ACTUAL_DATE] DATETIME NULL,
[EVACUATION_REASON_FOR_DELAY] NVARCHAR(250) NULL,
[EVACUATION_TRANSFER_EVACUATE_TO] NVARCHAR(250) NULL,
[EVACUATION_EQUIP_SUPPLY_REQUIREMENTS] NVARCHAR(250) NULL,
[EVACUATION_TRANSPORTATION_CARE_LEVEL] NVARCHAR(250) NULL,
[EVACUATION_ENROUTE_MEDICAL_ATTENDANT] NVARCHAR(250) NULL,
[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT] NVARCHAR(250) NULL,
[EVACUATION_TRANSPORTATION_TYPE_ID] INT NULL,
[EVACUATION_TRANSPORTATION_PROVIDER_ID] INT NULL,
[EVACUATION_TRANSPORTATION_COMMENTS] NVARCHAR(250) NULL,
[EVACUATION_DESTINATION_ADDRESS] NVARCHAR(250) NULL,
[EVACUATION_DESTINATION_CITY_STATE] NVARCHAR(250) NULL,
[EVACUATION_DESTINATION_POC_TELEPHONE] NVARCHAR(100) NULL,
[EVACUATION_ORIGINATOR_POC_TELEPHONE] NVARCHAR(100) NULL,
[EVACUATION_COMMENTS] NVARCHAR(500) NULL,
[EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER] INT NULL, 
[EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER] INT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
-- Triggers

SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Waiting_List_AfterDelete] 
   ON  [dbo].[WAITING_LIST] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Waiting_List_H]
			    (ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID,FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,
					REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, COMMENTS, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
					EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
					EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
					EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER)
		SELECT	ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),
				REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, COMMENTS, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
				EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
				EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
				EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER
		FROM deleted;

END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Waiting_List_AfterInsert] 
   ON  [dbo].[WAITING_LIST] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Waiting_List_H]
			    (ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID,FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,
					REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
					EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
					EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
					EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER )
		SELECT	ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),
				REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
				EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
				EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
				EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER 
		FROM inserted; 
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Waiting_List_AfterUpdate] 
   ON  [dbo].[WAITING_LIST] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @PK INT, @SID VARCHAR(250), @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[Waiting_List_H]
			    (ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID,FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,
					REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, COMMENTS, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
					EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
					EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
					EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER )
		SELECT	ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),
				REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, COMMENTS, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
				EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
				EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
				EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER 
		FROM inserted;	


END
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER [dbo].[utg_Waiting_List_InsteadOfInsert] 
   ON  [dbo].[WAITING_LIST]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[WAITING_LIST]
				(ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, _ssis_timestamp, CREATED, CREATEDBY,
					REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
					EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
					EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
					EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER )
		SELECT	ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, _ssis_timestamp, GETUTCDATE(), 
				dbo.ufn_Get_BMS_User_Name(), REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
				EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
				EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
				EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER 
		FROM inserted;

	ELSE
		INSERT INTO [dbo].[WAITING_LIST]
			(ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, _ssis_timestamp,
				REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
				EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
				EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
				EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER )
		SELECT	ACT_ID, FACILITY_UID, VISTA_SITE_UID, WAITING_AREA_ID, PROBLEM, FEE_DISPOSITION_ID, CONTRACT_FEE_ID, AUTHORIZED_FEE_ID, SERVICE_RECEIVING_FEE_ID, REASON_USING_FEE_ID, FEE_COMMENTS, REMOVED_DATE, TYPE_OF_BED_WARD, _ssis_timestamp,
				REQUESTED_BED_UID, REQUESTED_BED_DATE, REQUESTED_DATE, IS_IN_HOUSE, IS_BED_IN_ISOLATION, LAST_EDIT_BY, WAIT_TIME_ALERT_DATE, IS_COMMUNITY_LIVING_CENTER, IS_EVACUATION_PATIENT, EVACUATION_DISPOSITION_STATUS_ID, EVACUATION_EXPECTED_DATE, EVACUATION_ACTUAL_DATE, EVACUATION_REASON_FOR_DELAY, EVACUATION_TRANSFER_EVACUATE_TO,
				EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, EVACUATION_TRANSPORTATION_CARE_LEVEL, EVACUATION_ENROUTE_MEDICAL_ATTENDANT, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, EVACUATION_TRANSPORTATION_TYPE_ID,
				EVACUATION_TRANSPORTATION_PROVIDER_ID, EVACUATION_TRANSPORTATION_COMMENTS, EVACUATION_DESTINATION_ADDRESS, EVACUATION_DESTINATION_CITY_STATE,
				EVACUATION_DESTINATION_POC_TELEPHONE, EVACUATION_ORIGINATOR_POC_TELEPHONE, EVACUATION_COMMENTS, EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER, EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER
		FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_Waiting_List_InsteadOfUpdate] 
   ON  [dbo].[WAITING_LIST] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[WAITING_LIST]
		SET FACILITY_UID = inserted.FACILITY_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			WAITING_AREA_ID = inserted.WAITING_AREA_ID,
			PROBLEM = inserted.PROBLEM,
			FEE_DISPOSITION_ID = inserted.FEE_DISPOSITION_ID,
			CONTRACT_FEE_ID = inserted.CONTRACT_FEE_ID,
			AUTHORIZED_FEE_ID = inserted.AUTHORIZED_FEE_ID,
			SERVICE_RECEIVING_FEE_ID = inserted.SERVICE_RECEIVING_FEE_ID,
			REASON_USING_FEE_ID = inserted.REASON_USING_FEE_ID,
			FEE_COMMENTS = inserted.FEE_COMMENTS,
			REMOVED_DATE = inserted.REMOVED_DATE,
			TYPE_OF_BED_WARD = inserted.TYPE_OF_BED_WARD,
			_ssis_timestamp = current_timestamp,																
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE(),
			REQUESTED_BED_UID = inserted.REQUESTED_BED_UID, 
			REQUESTED_BED_DATE = inserted.REQUESTED_BED_DATE, 
			REQUESTED_DATE = inserted.REQUESTED_DATE,
			IS_IN_HOUSE = inserted.IS_IN_HOUSE,
			LAST_EDIT_BY = inserted.LAST_EDIT_BY,
			COMMENTS = inserted.COMMENTS,
			IS_BED_IN_ISOLATION = inserted.IS_BED_IN_ISOLATION,
			WAIT_TIME_ALERT_DATE = inserted.WAIT_TIME_ALERT_DATE,
			IS_COMMUNITY_LIVING_CENTER = inserted.IS_COMMUNITY_LIVING_CENTER, 
			IS_EVACUATION_PATIENT = inserted.IS_EVACUATION_PATIENT,
			EVACUATION_DISPOSITION_STATUS_ID = inserted.EVACUATION_DISPOSITION_STATUS_ID, 
			EVACUATION_EXPECTED_DATE = inserted.EVACUATION_EXPECTED_DATE, 
			EVACUATION_ACTUAL_DATE = inserted.EVACUATION_ACTUAL_DATE, 
			EVACUATION_REASON_FOR_DELAY = inserted.EVACUATION_REASON_FOR_DELAY, 
			EVACUATION_TRANSFER_EVACUATE_TO = inserted.EVACUATION_TRANSFER_EVACUATE_TO,
			EVACUATION_EQUIP_SUPPLY_REQUIREMENTS = inserted.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, 
			EVACUATION_TRANSPORTATION_CARE_LEVEL = inserted.EVACUATION_TRANSPORTATION_CARE_LEVEL, 
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT = inserted.EVACUATION_ENROUTE_MEDICAL_ATTENDANT, 
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT = inserted.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, 
			EVACUATION_TRANSPORTATION_TYPE_ID = inserted.EVACUATION_TRANSPORTATION_TYPE_ID,
			EVACUATION_TRANSPORTATION_PROVIDER_ID = inserted.EVACUATION_TRANSPORTATION_PROVIDER_ID, 
			EVACUATION_TRANSPORTATION_COMMENTS = inserted.EVACUATION_TRANSPORTATION_COMMENTS, 
			EVACUATION_DESTINATION_ADDRESS = inserted.EVACUATION_DESTINATION_ADDRESS, 
			EVACUATION_DESTINATION_CITY_STATE = inserted.EVACUATION_DESTINATION_CITY_STATE,
			EVACUATION_DESTINATION_POC_TELEPHONE = inserted.EVACUATION_DESTINATION_POC_TELEPHONE, 
			EVACUATION_ORIGINATOR_POC_TELEPHONE = inserted.EVACUATION_ORIGINATOR_POC_TELEPHONE, 
			EVACUATION_COMMENTS = inserted.EVACUATION_COMMENTS,
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER = inserted.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER,
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER = inserted.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER				
		FROM [dbo].[WAITING_LIST]
		INNER JOIN inserted ON inserted.act_id = [dbo].[WAITING_LIST].act_id;
	 ELSE
	    UPDATE [dbo].[WAITING_LIST]
		SET FACILITY_UID = inserted.FACILITY_UID,
			VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
			WAITING_AREA_ID = inserted.WAITING_AREA_ID,
			PROBLEM = inserted.PROBLEM,
			FEE_DISPOSITION_ID = inserted.FEE_DISPOSITION_ID,
			CONTRACT_FEE_ID = inserted.CONTRACT_FEE_ID,
			AUTHORIZED_FEE_ID = inserted.AUTHORIZED_FEE_ID,
			SERVICE_RECEIVING_FEE_ID = inserted.SERVICE_RECEIVING_FEE_ID,
			REASON_USING_FEE_ID = inserted.REASON_USING_FEE_ID,
			FEE_COMMENTS = inserted.FEE_COMMENTS,
			REMOVED_DATE = inserted.REMOVED_DATE,
			TYPE_OF_BED_WARD = inserted.TYPE_OF_BED_WARD,
			_ssis_timestamp = current_timestamp,
			REQUESTED_BED_UID = inserted.REQUESTED_BED_UID, 
			REQUESTED_BED_DATE = inserted.REQUESTED_BED_DATE, 
			REQUESTED_DATE = inserted.REQUESTED_DATE,
			IS_IN_HOUSE = inserted.IS_IN_HOUSE,
			LAST_EDIT_BY = inserted.LAST_EDIT_BY,
			COMMENTS = inserted.COMMENTS,
			IS_BED_IN_ISOLATION = inserted.IS_BED_IN_ISOLATION,
			WAIT_TIME_ALERT_DATE = inserted.WAIT_TIME_ALERT_DATE,
			IS_COMMUNITY_LIVING_CENTER = inserted.IS_COMMUNITY_LIVING_CENTER, 
			IS_EVACUATION_PATIENT = inserted.IS_EVACUATION_PATIENT,
			EVACUATION_DISPOSITION_STATUS_ID = inserted.EVACUATION_DISPOSITION_STATUS_ID, 
			EVACUATION_EXPECTED_DATE = inserted.EVACUATION_EXPECTED_DATE, 
			EVACUATION_ACTUAL_DATE = inserted.EVACUATION_ACTUAL_DATE, 
			EVACUATION_REASON_FOR_DELAY = inserted.EVACUATION_REASON_FOR_DELAY, 
			EVACUATION_TRANSFER_EVACUATE_TO = inserted.EVACUATION_TRANSFER_EVACUATE_TO,
			EVACUATION_EQUIP_SUPPLY_REQUIREMENTS = inserted.EVACUATION_EQUIP_SUPPLY_REQUIREMENTS, 
			EVACUATION_TRANSPORTATION_CARE_LEVEL = inserted.EVACUATION_TRANSPORTATION_CARE_LEVEL, 
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT = inserted.EVACUATION_ENROUTE_MEDICAL_ATTENDANT, 
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT = inserted.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT, 
			EVACUATION_TRANSPORTATION_TYPE_ID = inserted.EVACUATION_TRANSPORTATION_TYPE_ID,
			EVACUATION_TRANSPORTATION_PROVIDER_ID = inserted.EVACUATION_TRANSPORTATION_PROVIDER_ID, 
			EVACUATION_TRANSPORTATION_COMMENTS = inserted.EVACUATION_TRANSPORTATION_COMMENTS, 
			EVACUATION_DESTINATION_ADDRESS = inserted.EVACUATION_DESTINATION_ADDRESS, 
			EVACUATION_DESTINATION_CITY_STATE = inserted.EVACUATION_DESTINATION_CITY_STATE,
			EVACUATION_DESTINATION_POC_TELEPHONE = inserted.EVACUATION_DESTINATION_POC_TELEPHONE, 
			EVACUATION_ORIGINATOR_POC_TELEPHONE = inserted.EVACUATION_ORIGINATOR_POC_TELEPHONE, 
			EVACUATION_COMMENTS = inserted.EVACUATION_COMMENTS,
			EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER = inserted.EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER,
			EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER = inserted.EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER			
		FROM [dbo].[WAITING_LIST]
		INNER JOIN inserted ON inserted.act_id = [dbo].[WAITING_LIST].act_id;

END
GO
CREATE trigger [dbo].[WAITING_LIST_tgg_ssis_delete] on [dbo].[WAITING_LIST] after delete as begin  delete [dbo].[WAITING_LIST_ssisdel] from [deleted] _xyz where [dbo].[WAITING_LIST_ssisdel].[ACT_ID]=[_xyz].[ACT_ID];  insert into [dbo].[WAITING_LIST_ssisdel]([ACT_ID], _ssis_timestamp)  select [ACT_ID], current_timestamp from [deleted];  end
GO
CREATE trigger [dbo].[WAITING_LIST_tgg_ssis_insert] on [dbo].[WAITING_LIST] after insert as begin delete [dbo].[WAITING_LIST_ssisdel]  from [inserted] _xyz where [dbo].[WAITING_LIST_ssisdel].[ACT_ID]=[_xyz].[ACT_ID] end
GO

-- Constraints
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [PK_WAITING_LIST] PRIMARY KEY CLUSTERED  ([ACT_ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [DF_WAITING_LIST_IS_BED_IN_ISOLATION] DEFAULT ((0)) FOR [IS_BED_IN_ISOLATION]
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_ACT] FOREIGN KEY ([ACT_ID]) REFERENCES [dbo].[ACT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_AUTHORIZED_FEE] FOREIGN KEY ([AUTHORIZED_FEE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_CONTRACT_FEE] FOREIGN KEY ([CONTRACT_FEE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_FEE_DISPOSITION] FOREIGN KEY ([FEE_DISPOSITION_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_REASON_USING_FEE] FOREIGN KEY ([REASON_USING_FEE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_SERVICE_RECEIVING_FEE] FOREIGN KEY ([SERVICE_RECEIVING_FEE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_WAITING_AREA] FOREIGN KEY ([WAITING_AREA_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_EVACUATION_DISPOSITION_STATUS] FOREIGN KEY ([EVACUATION_DISPOSITION_STATUS_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_EVACUATION_TRANSPORTATION_TYPE] FOREIGN KEY ([EVACUATION_TRANSPORTATION_TYPE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[WAITING_LIST] ADD CONSTRAINT [FK_WAITING_LIST_CONCEPT_EVACUATION_TRANSPORTATION_PROVIDER] FOREIGN KEY ([EVACUATION_TRANSPORTATION_PROVIDER_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_FAC_ID_REMOVED_DATE_IN_HOUSE] ON [dbo].[WAITING_LIST] 
(
	[FACILITY_UID] ASC,
	[REMOVED_DATE] ASC,
	[IS_IN_HOUSE] ASC
)
INCLUDE ( [PROBLEM],
[FEE_COMMENTS],
[TYPE_OF_BED_WARD],
[REQUESTED_BED_DATE],
[REQUESTED_DATE],
[IS_BED_IN_ISOLATION],
[LAST_EDIT_BY],
[WAIT_TIME_ALERT_DATE],
[IS_COMMUNITY_LIVING_CENTER]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_REMOVE_DATE_ACT_ID] ON [dbo].[WAITING_LIST] ([REMOVED_DATE])
INCLUDE ([ACT_ID])
GO

CREATE NONCLUSTERED INDEX [IDX_REMOVED_DATE_REQUESTED_BED_UID] ON [dbo].[WAITING_LIST] 
(
	 [REMOVED_DATE] ASC, [REQUESTED_BED_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[WAITING_LIST] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX [IDX_VISTA_SITE_UID_REMOVED_DATE] ON [dbo].[WAITING_LIST] 
([VISTA_SITE_UID], [REMOVED_DATE])	
GO

-- Extended Properties
EXEC sp_addextendedproperty N'MS_Description', N'Admission request table.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the admission and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'ACT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the authorized fee (concept).', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'AUTHORIZED_FEE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the fee contract (concept).', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'CONTRACT_FEE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The Id of the facility that was requested for the admission.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'FACILITY_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Fee comments.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'FEE_COMMENTS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Fee utilization - concept.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'FEE_DISPOSITION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the presented problem or diagnostic of  the patient.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'PROBLEM'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the reason using fee (concept).', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'REASON_USING_FEE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Removed from waiting list date time.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'REMOVED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date when the bed was requested.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'REQUESTED_BED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the bed requested.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'REQUESTED_BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the service receiving fee (concept).', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'SERVICE_RECEIVING_FEE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type of bed or ward that the patient needs.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'TYPE_OF_BED_WARD'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indicates the area where the patient waits to be admitted.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'WAITING_AREA_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient already admitted to current facility.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'IS_IN_HOUSE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Comments.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'COMMENTS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Whether bed is in isolation or not.' , N'SCHEMA', N'dbo', N'TABLE', N'WAITING_LIST', N'COLUMN', N'IS_BED_IN_ISOLATION'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Wait time alert.' , N'SCHEMA', N'dbo', N'TABLE', N'WAITING_LIST', N'COLUMN', N'WAIT_TIME_ALERT_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Community Living Center (CLC) patients and future scheduled patients' , N'SCHEMA', N'dbo', N'TABLE', N'WAITING_LIST', N'COLUMN', N'IS_COMMUNITY_LIVING_CENTER'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Whether patient is in evacuation or not.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'IS_EVACUATION_PATIENT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation disposition status id', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_DISPOSITION_STATUS_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation expected pick-up date.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_EXPECTED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation actual pick-up date.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_ACTUAL_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation reason fro delay.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_REASON_FOR_DELAY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation transfer/Evacuate to.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_TRANSFER_EVACUATE_TO'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Equip/Supply Requirements.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_EQUIP_SUPPLY_REQUIREMENTS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Transportation Care Level.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_TRANSPORTATION_CARE_LEVEL'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Enroute Medical Attendant.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_ENROUTE_MEDICAL_ATTENDANT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Enroute Non-Medical Attendant.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Transportation Type Id.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_TRANSPORTATION_TYPE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Transportation Provider Id.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_TRANSPORTATION_PROVIDER_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Transportation Comments.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_TRANSPORTATION_COMMENTS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Destination Address.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_DESTINATION_ADDRESS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Destination City/State.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_DESTINATION_CITY_STATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Destination POC Phone.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_DESTINATION_POC_TELEPHONE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Originator POC Phone.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_ORIGINATOR_POC_TELEPHONE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Comments.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_COMMENTS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Enroute Medical Attendant Number.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_ENROUTE_MEDICAL_ATTENDANT_NUMBER'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Evacuation Enroute Non-Medical Attendant Number.', 'SCHEMA', N'dbo', 'TABLE', N'WAITING_LIST', 'COLUMN', N'EVACUATION_ENROUTE_NON_MEDICAL_ATTENDANT_NUMBER'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The vista site id.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST', @level2type=N'COLUMN',@level2name=N'VISTA_SITE_UID'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The user who last edited the record.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST', @level2type=N'COLUMN',@level2name=N'LAST_EDIT_BY'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The date when the patient was added in the waiting list.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'WAITING_LIST', @level2type=N'COLUMN',@level2name=N'REQUESTED_DATE'
GO
