
CREATE TABLE [dbo].[BED_UNAVAILABLE]
(
[ACT_ID] [int] NOT NULL,
[DIVISION_UID] [uniqueidentifier] NULL,
[BED_UID] [uniqueidentifier] NOT NULL,
[VISTA_SITE_UID] [uniqueidentifier] NULL,
[TYPE_ID] [int] NULL,
[REASON_ID] [int] NULL,
[IS_UNAVAILABLE_FROM_VISTA] [bit] NOT NULL CONSTRAINT [DF_BED_UNAVAILABLE_IsUnavailableFromVistA] DEFAULT ((0)),
[CREATIONBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EDITEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[EDITED_DATE] [datetime] NULL,
[EXPECTED_COMPLETED_DATE] [DATETIME] NULL,
[COMPLETEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[COMPLETED_DATE] [datetime] NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__BED_UNAVA___ssis__03C67B1A] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
)
GO
-- Triggers

create trigger [dbo].[BED_UNAVAILABLE_tgg_ssis_delete] on dbo.BED_UNAVAILABLE after delete as begin  delete [dbo].[BED_UNAVAILABLE_ssisdel] from [deleted] _xyz where [dbo].[BED_UNAVAILABLE_ssisdel].[ACT_ID]=[_xyz].[ACT_ID];  insert into [dbo].[BED_UNAVAILABLE_ssisdel]([ACT_ID], _ssis_timestamp)  select [ACT_ID], current_timestamp from [deleted];  end
GO
create trigger [dbo].[BED_UNAVAILABLE_tgg_ssis_insert] on dbo.BED_UNAVAILABLE after insert as begin delete [dbo].[BED_UNAVAILABLE_ssisdel]  from [inserted] _xyz where [dbo].[BED_UNAVAILABLE_ssisdel].[ACT_ID]=[_xyz].[ACT_ID] end
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_AfterDelete] 
   ON  [dbo].[BED_UNAVAILABLE] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
     BEGIN 
		INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Unavailable_H]
			   (ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,CREATION_BY, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
			   VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE)
			SELECT	ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE
			FROM deleted;
	 END		
END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_AfterInsert] 
   ON  [dbo].[BED_UNAVAILABLE] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

    IF (UPPER(@HISTORY_VALUE) = 'Y')
		INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Unavailable_H]
			   (ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, CREATION_BY, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
			   VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE)
			SELECT ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE
			FROM inserted;


END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_AfterUpdate] 
   ON  [dbo].[BED_UNAVAILABLE] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)

    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';

	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[Bed_Unavailable_H]
			    (ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY,  CREATION_BY, EDITED_BY, EDITED_DATE,COMPLETED_BY,COMPLETED_DATE,
			   VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE)
			SELECT ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE,	VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE
			FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_InsteadOfInsert] 
   ON  [dbo].[BED_UNAVAILABLE]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
     BEGIN
		INSERT INTO [dbo].[Bed_Unavailable]
			   (ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp, CREATED, CREATEDBY,  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, 
				VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE)
			SELECT ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(),  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,	COMPLETED_DATE, VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE
			  FROM inserted;

	  END
	ELSE
		INSERT INTO [dbo].[Bed_Unavailable]
			    (ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp,  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE)
			SELECT ACT_ID, DIVISION_UID, BED_UID, TYPE_ID, REASON_ID, _ssis_timestamp,  CREATIONBY, EDITEDBY, EDITED_DATE,COMPLETEDBY,COMPLETED_DATE, VISTA_SITE_UID, IS_UNAVAILABLE_FROM_VISTA, EXPECTED_COMPLETED_DATE
			  FROM inserted;

END
GO
CREATE TRIGGER [dbo].[utg_Bed_Unavailable_InsteadOfUpdate] 
   ON  [dbo].[BED_UNAVAILABLE] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @AUDIT_VALUE NVARCHAR(50)

    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';

    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[Bed_Unavailable]
		SET  DIVISION_UID = inserted.DIVISION_UID,
			BED_UID = inserted.BED_UID,			
			TYPE_ID = inserted.TYPE_ID,
			REASON_ID = inserted.REASON_ID,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE(),
		    CREATIONBY = inserted.CREATIONBY, 
		    EDITEDBY =  inserted.EDITEDBY ,
		    EDITED_DATE =  inserted.EDITED_DATE, 
		    COMPLETEDBY =  inserted.COMPLETEDBY,
		    COMPLETED_DATE	=  inserted.COMPLETED_DATE,
		    VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
		    IS_UNAVAILABLE_FROM_VISTA = inserted.IS_UNAVAILABLE_FROM_VISTA,
		    EXPECTED_COMPLETED_DATE = inserted.EXPECTED_COMPLETED_DATE
		FROM [dbo].[Bed_Unavailable]
		INNER JOIN inserted ON inserted.act_id = [dbo].[Bed_Unavailable].act_id;

	 ELSE
	    UPDATE [dbo].[Bed_Unavailable]
		SET  DIVISION_UID = inserted.DIVISION_UID,
			BED_UID = inserted.BED_UID,
			TYPE_ID = inserted.TYPE_ID,
			REASON_ID = inserted.REASON_ID,
			_ssis_timestamp = current_timestamp,
			CREATIONBY = inserted.CREATIONBY, 
		    EDITEDBY =  inserted.EDITEDBY ,
		    EDITED_DATE =  inserted.EDITED_DATE, 
		    COMPLETEDBY =  inserted.COMPLETEDBY,
		    COMPLETED_DATE	=  inserted.COMPLETED_DATE,
		    VISTA_SITE_UID = inserted.VISTA_SITE_UID, 
		    IS_UNAVAILABLE_FROM_VISTA = inserted.IS_UNAVAILABLE_FROM_VISTA,
		    EXPECTED_COMPLETED_DATE = inserted.EXPECTED_COMPLETED_DATE
		FROM [dbo].[Bed_Unavailable]
		INNER JOIN inserted ON inserted.act_id = [dbo].[Bed_Unavailable].act_id;

END
GO

-- Constraints
ALTER TABLE [dbo].[BED_UNAVAILABLE] ADD CONSTRAINT [PK_BED_UNAVAILABLE] PRIMARY KEY CLUSTERED  ([ACT_ID])
GO
ALTER TABLE [dbo].[BED_UNAVAILABLE] ADD CONSTRAINT [FK_BED_UNAVAILABLE_ACT] FOREIGN KEY ([ACT_ID]) REFERENCES [dbo].[ACT] ([ID])
GO
ALTER TABLE [dbo].[BED_UNAVAILABLE] ADD CONSTRAINT [FK_BED_UNAVAILABLE_CONCEPT_REASON] FOREIGN KEY ([REASON_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO
ALTER TABLE [dbo].[BED_UNAVAILABLE] ADD CONSTRAINT [FK_BED_UNAVAILABLE_CONCEPT_TYPE] FOREIGN KEY ([TYPE_ID]) REFERENCES [dbo].[CONCEPT] ([ID])
GO


--Indexes
CREATE NONCLUSTERED INDEX [IDX_VISTA_SITE_TYPE_ID] ON [dbo].[BED_UNAVAILABLE] 
(
	[VISTA_SITE_UID] ASC,
	[IS_UNAVAILABLE_FROM_VISTA] ASC,
	[TYPE_ID] ASC,
	[COMPLETED_DATE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_TYPE_DATE] ON [dbo].[BED_UNAVAILABLE] 
(
	[BED_UID] ASC,
	[TYPE_ID] ASC,
	[COMPLETED_DATE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_DATE_VISTA_SITE] ON [dbo].[BED_UNAVAILABLE] 
(
	[BED_UID] ASC,
	[COMPLETED_DATE] ASC,
	[VISTA_SITE_UID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_COMPLETED] ON [dbo].[BED_UNAVAILABLE] 
(
	[BED_UID] ASC,
	[COMPLETEDBY] ASC,
	[COMPLETED_DATE] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_TYPE_REASON_DIVISION_VISTA_SITE] ON [dbo].[BED_UNAVAILABLE] 
(
	[TYPE_ID] ASC,
	[REASON_ID] ASC,
	[BED_UID] ASC,
	[DIVISION_UID] ASC,
	[VISTA_SITE_UID] ASC
)
INCLUDE ( [IS_UNAVAILABLE_FROM_VISTA],
[CREATIONBY],
[EDITEDBY],
[EDITED_DATE],
[EXPECTED_COMPLETED_DATE],
[COMPLETEDBY],
[COMPLETED_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_BED_ACT] ON [dbo].[BED_UNAVAILABLE] 
(
	[BED_UID] ASC
)
INCLUDE ( [ACT_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_TYPE_REASON] ON [dbo].[BED_UNAVAILABLE] 
(
	[ACT_ID] ASC,
	[TYPE_ID] ASC,
	[REASON_ID] ASC
)
INCLUDE ( [IS_UNAVAILABLE_FROM_VISTA]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_SSIS_MODIFY] ON [dbo].[BED_UNAVAILABLE] 
(
	[_ssis_timestamp] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IDX_BED_UID_COMPLETED_DATE] ON [dbo].[BED_UNAVAILABLE] 
(
	[BED_UID] ASC,
	[COMPLETED_DATE] ASC
)
INCLUDE (ACT_ID)
WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 100) ON [PRIMARY]
GO

CREATE INDEX [IDX_COMPLETED_DATE] ON [dbo].[BED_UNAVAILABLE] 
([COMPLETED_DATE])	
GO

CREATE INDEX [IDX_IS_UNAVAIL_FRM_VISTA] ON [dbo].[BED_UNAVAILABLE] 
([IS_UNAVAILABLE_FROM_VISTA]) 
INCLUDE ([ACT_ID], [TYPE_ID])
GO

CREATE INDEX IDX_VISTA_SITE_UID_WITH_INCLUDE ON [dbo].[BED_UNAVAILABLE] ([VISTA_SITE_UID]) INCLUDE ([ACT_ID], [BED_UID], [IS_UNAVAILABLE_FROM_VISTA])
GO  

-- Extended Properties
EXEC sp_addextendedproperty N'MS_Description', N'Bed unavailable table.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sp_addextendedproperty N'MS_Description', N'ID of the table and reference key to the ACT table.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'ACT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Beds''id.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'BED_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when a BMS user completed an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'COMPLETED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the user who completed an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'COMPLETEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the user who created an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'CREATIONBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Ward''s id.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'DIVISION_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when a BMS user updated an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'EDITED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the user who updated an unvailable reason for bed.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'EDITEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Flag which indicates if the bed is unavailable from VistA(if true) or from BMS (if false).', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'IS_UNAVAILABLE_FROM_VISTA'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The reason for which the bed is unavailable.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'REASON_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Type column (concept).', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'TYPE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the facility where the bed is located.', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'VISTA_SITE_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The time/date expected out of service ends for the bed', 'SCHEMA', N'dbo', 'TABLE', N'BED_UNAVAILABLE', 'COLUMN', N'EXPECTED_COMPLETED_DATE'
GO
