CREATE TABLE [dbo].[ACT]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[PATIENT_UID] [UNIQUEIDENTIFIER] NULL,
[CREATION_DATE] [datetime] NULL,
[CANCELED_DATE] [datetime] NULL,
[PARENT_ACT_ID] [int] NULL,
[FLOW_ID] [uniqueidentifier] NOT NULL,
[DOMAIN_ID] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[IEN] [varchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__ACT___ssis_times__07420643] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL,
[CREATION_UTC_DATE] [datetime] NULL 
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[ACT_tgg_ssis_delete] on dbo.ACT after delete as begin  delete [dbo].[ACT_ssisdel] from [deleted] _xyz where [dbo].[ACT_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[ACT_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[ACT_tgg_ssis_insert] on dbo.ACT after insert as begin delete [dbo].[ACT_ssisdel]  from [inserted] _xyz where [dbo].[ACT_ssisdel].[ID]=[_xyz].[ID] end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_ACT_AfterDelete] 
   ON  dbo.ACT 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
      INSERT INTO $(varBMS_HISTORY).[dbo].[ACT_H]
			   (ID, PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, CREATION_UTC_DATE)
			SELECT ID, PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), CREATION_UTC_DATE
			FROM deleted;
	 	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_ACT_AfterInsert] 
   ON  dbo.ACT 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[ACT_H]
			   (ID, PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, CREATION_UTC_DATE)
			SELECT ID, PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), CREATION_UTC_DATE
			FROM inserted;
    
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_ACT_AfterUpdate] 
   ON  dbo.ACT 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
	    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	   INSERT INTO $(varBMS_HISTORY).[dbo].[ACT_H]
			   (ID, PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, TRANSACTION_TYPE_CODE, DATE, CREATED_BY, CREATION_UTC_DATE)
			SELECT ID, PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name(), CREATION_UTC_DATE
			FROM inserted;
	 
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_ACT_InsteadOfInsert] 
   ON  dbo.ACT
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		INSERT INTO [dbo].[ACT]
			   (PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, _ssis_timestamp, CREATEDBY, CREATED, CREATION_UTC_DATE)
			SELECT PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, _ssis_timestamp, dbo.ufn_Get_BMS_User_Name(), GETUTCDATE(), CREATION_UTC_DATE
			  FROM inserted;
	ELSE
		INSERT INTO [dbo].[ACT]
			   (PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, _ssis_timestamp, CREATION_UTC_DATE)
			SELECT PATIENT_UID, CREATION_DATE, CANCELED_DATE, PARENT_ACT_ID, FLOW_ID, DOMAIN_ID, IEN, _ssis_timestamp, CREATION_UTC_DATE
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_ACT_InsteadOfUpdate] 
   ON  dbo.ACT 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
        IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[ACT]
		SET PATIENT_UID = inserted.PATIENT_UID,
			CREATION_DATE = inserted.CREATION_DATE,
			CANCELED_DATE = inserted.CANCELED_DATE,
			PARENT_ACT_ID = inserted.PARENT_ACT_ID,
			FLOW_ID = inserted.FLOW_ID,
			DOMAIN_ID = inserted.DOMAIN_ID,
			IEN = inserted.IEN,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE(),
			CREATION_UTC_DATE= inserted.CREATION_UTC_DATE
		FROM [dbo].[ACT]
		INNER JOIN inserted ON inserted.id = [dbo].[ACT].id;
	 ELSE
	    UPDATE [dbo].[ACT]
		SET PATIENT_UID = inserted.PATIENT_UID,
			CREATION_DATE = inserted.CREATION_DATE,
			CANCELED_DATE = inserted.CANCELED_DATE,
			PARENT_ACT_ID = inserted.PARENT_ACT_ID,
			FLOW_ID = inserted.FLOW_ID,
			DOMAIN_ID = inserted.DOMAIN_ID,
			IEN = inserted.IEN,
			_ssis_timestamp = current_timestamp,
			CREATION_UTC_DATE = inserted.CREATION_UTC_DATE
		FROM [dbo].[ACT]
		INNER JOIN inserted ON inserted.id = [dbo].[ACT].id;

END
GO

-- Constraints
ALTER TABLE [dbo].[ACT] ADD CONSTRAINT [PK_ADMISSION] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[ACT] ADD CONSTRAINT [FK_ACT_ACT] FOREIGN KEY ([PARENT_ACT_ID]) REFERENCES [dbo].[ACT] ([ID])
GO
ALTER TABLE [dbo].[ACT] ADD CONSTRAINT [DF_ACT_CREATION_UTC_DATE]  DEFAULT (getutcdate()) FOR [CREATION_UTC_DATE]
GO

-- Indexes
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[ACT] ([_ssis_timestamp]) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IX_ACT_CANCELED_DATE] ON [dbo].[ACT] ([CANCELED_DATE]) INCLUDE ([DOMAIN_ID], [FLOW_ID], [ID], [PARENT_ACT_ID])
GO
CREATE NONCLUSTERED INDEX [IX_ACT_FLOW_ID] ON [dbo].[ACT] ([FLOW_ID])
GO
CREATE NONCLUSTERED INDEX [IX_PARENT_ACT_ID] ON [dbo].[ACT] 
(
	[PARENT_ACT_ID] ASC
)
INCLUDE ( [ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE NONCLUSTERED INDEX [IX_PATIENT_UID] ON [dbo].[ACT] 
(
	[PATIENT_UID] ASC,
	[FLOW_ID] ASC
)
INCLUDE ( [ID],
[CREATION_UTC_DATE]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE INDEX IDX_CREATION_DATE_WITH_INCLUDE ON [dbo].[ACT] ([CREATION_DATE]) INCLUDE ([ID], [PATIENT_UID], [CANCELED_DATE], [PARENT_ACT_ID], [FLOW_ID], [DOMAIN_ID])      
GO

-- Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Main entity for all documents (HL7 ACT).', 'SCHEMA', N'dbo', 'TABLE', N'ACT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of cancellation.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'CANCELED_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Date of creation.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'CREATION_DATE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'A logical grouping of acts.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'DOMAIN_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the flow.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'FLOW_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Identity number and primary key of the table.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Indentity column imported from VistA(VistA IEN)', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the parent act.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'PARENT_ACT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the patient.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'PATIENT_UID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'ACT', 'COLUMN', N'_ssis_timestamp'
GO
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The UTC date and time when the act was created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ACT', @level2type=N'COLUMN',@level2name=N'CREATION_UTC_DATE'
GO