CREATE TABLE [dbo].[CONCEPT]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[CODE] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CODE_SYSTEM_NAME] [varchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[DISPLAY_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[_ssis_timestamp] [datetime] NULL CONSTRAINT [DF__CONCEPT___ssis_t__2F4FF79D] DEFAULT (getdate()),
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[CONCEPT_tgg_ssis_delete] on [dbo].[CONCEPT] after delete as begin  delete [dbo].[CONCEPT_ssisdel] from [deleted] _xyz where [dbo].[CONCEPT_ssisdel].[ID]=[_xyz].[ID];  insert into [dbo].[CONCEPT_ssisdel]([ID], _ssis_timestamp)  select [ID], current_timestamp from [deleted];  end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
create trigger [dbo].[CONCEPT_tgg_ssis_insert] on [dbo].[CONCEPT] after insert as begin delete [dbo].[CONCEPT_ssisdel]  from [inserted] _xyz where [dbo].[CONCEPT_ssisdel].[ID]=[_xyz].[ID] end
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Concept_AfterDelete] 
   ON  [dbo].[CONCEPT] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Concept_H]
			   (ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Concept_AfterInsert] 
   ON  [dbo].[CONCEPT] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Concept_H]
			   (ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
       
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Concept_AfterUpdate] 
   ON  [dbo].[CONCEPT] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
    IF (UPPER(@HISTORY_VALUE) = 'Y')
	 	INSERT INTO $(varBMS_HISTORY).[dbo].[Concept_H]
			   (ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Concept_InsteadOfInsert] 
   ON  [dbo].[CONCEPT]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
    	INSERT INTO [dbo].[Concept]
			   (CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, _ssis_timestamp, CREATED, CREATEDBY)
			SELECT CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, _ssis_timestamp, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	 
	ELSE
		INSERT INTO [dbo].[Concept]
			   (CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, _ssis_timestamp)
			SELECT CODE, CODE_SYSTEM, CODE_SYSTEM_NAME, DISPLAY_NAME, _ssis_timestamp
			  FROM inserted;	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Concept_InsteadOfUpdate] 
   ON  [dbo].[CONCEPT] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
		UPDATE [dbo].[Concept]
		SET CODE = inserted.CODE,
			CODE_SYSTEM = inserted.CODE_SYSTEM,
			CODE_SYSTEM_NAME = inserted.CODE_SYSTEM_NAME,
			DISPLAY_NAME = inserted.DISPLAY_NAME,
			_ssis_timestamp = current_timestamp,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Concept]
		INNER JOIN inserted ON inserted.id = [dbo].[Concept].id;
	
	 ELSE
	    UPDATE [dbo].[Concept]
		SET CODE = inserted.CODE,
			CODE_SYSTEM = inserted.CODE_SYSTEM,
			CODE_SYSTEM_NAME = inserted.CODE_SYSTEM_NAME,
			DISPLAY_NAME = inserted.DISPLAY_NAME,
			_ssis_timestamp = current_timestamp
		FROM [dbo].[Concept]
		INNER JOIN inserted ON inserted.id = [dbo].[Concept].id;

END
GO

--Constraints
ALTER TABLE [dbo].[CONCEPT] ADD CONSTRAINT [PK_CONCEPT] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO

--Index
CREATE NONCLUSTERED INDEX [idx_ssis_modify] ON [dbo].[CONCEPT] ([_ssis_timestamp]) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_CODE_CODE_SYSTEM] ON [dbo].[CONCEPT] 
(
	[CODE] ASC,
	[CODE_SYSTEM] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [IDX_CODE_CS_ID_DISPLAY] ON [dbo].[CONCEPT] 
(
	[CODE] ASC,
	[CODE_SYSTEM] ASC
)
INCLUDE ( [ID],
[DISPLAY_NAME]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

CREATE INDEX IDX_CODE_SYSTEM_NAME_WITH_INCLUDE ON [dbo].[CONCEPT] ([CODE_SYSTEM_NAME]) INCLUDE ([ID], [CODE])     
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept table.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept - code.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'CODE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept - code system.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'CODE_SYSTEM'
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept''s code system name.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'CODE_SYSTEM_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'EVS concept''s code display name.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'DISPLAY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Identity number and primary key of the table.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'UPDATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the row has been inserted or modified.', 'SCHEMA', N'dbo', 'TABLE', N'CONCEPT', 'COLUMN', N'_ssis_timestamp'
GO