﻿var autoScrollIntervalId;
$(document).ready(function () {
    var expr = new RegExp('>[ \t\r\n\v\f]*<', 'g');
    var tbls = $('table[name=tblWhiteboard]');
    for (i = 0; i < tbls.length; i++) {
        var tbhtml = $(tbls[i]).html();
        $(tbls[i]).html(tbhtml.replace(expr, '><'));
    }
    $('.checkStaffBtn').click(function () {
        $('#buttonStaffHidden').click();
    });
    var scrollRate = parseInt($('#ScrollRateSelected').val());
    if (scrollRate > 0) {
        var height = $(window).height() - 270;
        if ($('table[name=tblWhiteboard]').height() > height) {
            $('table[name=tblWhiteboard]').tableScroll({ height: height });
        }
        else {
            $('table[name=tblWhiteboard]').tableScroll({ height: $('table[name=tblWhiteboard]').height() });
        }
        if ($('#divContainerDataTwo')) {
            $('#divContainerDataTwo').css({ "min-width": (($('.tablescroll_head').width() * 2) + 30) + "px" });
        }
    }
    else {
        var tbls = $('table[name=tblWhiteboard]');
        var body;
        for (i = 0; i < tbls.length; i++) {
            $(tbls[i]).css('border-collapse', 'collapse');
            body = $(tbls[i]).find('tbody');
            $(body).css('border-top', '1px solid #DDDDDD');
            $(body).css('border-bottom', '1px solid #DDDDDD');
            $(body).css('border-right', '1px solid #DDDDDD');
        }
    }

    //add sorting
    SortingFunctionality();
    //add click events for staff buttons
    ButtonsManageStaff();

    // keep the scroll in the same position on window reload    
    if (scrollRate > 0 && $('.tablescroll_wrapper').height() >= $(window).height() - 270) {
        var div = $('.tablescroll_wrapper');
        for (i = 0; i < div.length; i++) {
            $(div[i]).scrollTop($('#ActualScrollValue').val());
        }
    }

    //Script for automated scrolling.        
    if (scrollRate > 0 && $('.tablescroll_wrapper').height() >= $(window).height() - 270)
        autoScrollIntervalId = setInterval(function() { autoScroll(); }, scrollRate * 1000);    

    var realRefreshRate = parseInt($('#hiddenRealRefreshRate').val()) - (parseInt($('#hiddenRefreshRate').val()) * parseInt($('#AjaxRefreshCount').val()));
    //Script for refreshing the page using ajax.
    if (realRefreshRate > parseInt($('#hiddenRefreshRate').val()))
        setTimeout(function () { refresh(); }, parseInt($('#hiddenRefreshRate').val()));

    //Script for refreshing the page(reload).
    if (realRefreshRate <= parseInt($('#hiddenRefreshRate').val()))
        setTimeout(function () { realRefresh(); }, realRefreshRate);
});

function realRefresh() {
    $('#ButtonRefreshHidden').click();
    if (parseInt($('#ScrollRateSelected').val()) > 0 && $('.tablescroll_wrapper').height() >= $(window).height() - 270) {        
        if (parseInt($('#ScrollRateSelected').val()) > 0)
            clearInterval(autoScrollIntervalId);
    }    
}

function refresh() {
    var jsModel = new WardWhiteboardViewModel($('#DivisionExtension').val(), $('#SplitScreen').val(), $('#DisplayPTCode').val(), $('#GenderColorCode').val(), $('#SortBySelected').val(), 
                            $('#DisplayFooterCensus').val(), $('#DisplayStaffAttendingSelected').val(), $('#ScrollRateSelected').val(), $('#ActualScrollValue').val(), $('#ActualScrollDirection').val(),
                            $('#FacilityCode').val(), $('#IsFromWhiteboardKiosk').val(), $('#AjaxRefreshCount').val());
    var jsonText = JSON.stringify(jsModel);
    var token = $.getAntiForgeryToken();
    var request = $.ajax({
        type: "POST",
        url: "WardWhiteBoardAjax",
        dataType: "html",
        data: { __RequestVerificationToken: token.value, model: jsonText },
        cache: false,
        success: function (data) {
            $("body").empty().html(data);            
            delete data;
        },
        error: function (x, e) {
            if (x.responseText.indexOf('<title>BMS User Login Page</title>') >= 0)
                window.location = '@Url.Action("LogOn", "Account")';
            else if (x.responseText.indexOf('<title>Unhandled Exception</title>') >= 0 || x.responseText.indexOf('<title>Unauthorized</title>') >= 0)
                document.body.innerHTML = x.responseText;
        }
    });
    jsModel = null;
    jsonText = null;
    token = null;

    if (request != null) {
        delete request.xmlHttpRequest;
        request.xmlHttpRequest = null;
        request.onreadystatechange = null; 
        request.abort = null;
        request = null;
    }
    if (parseInt($('#ScrollRateSelected').val()) > 0 && $('.tablescroll_wrapper').height() >= $(window).height() - 270)      
        clearInterval(autoScrollIntervalId);
}

var WardWhiteboardViewModel = function (divisionId, splitScreen, displayPTCode, genderColorCode, sortBy, displayFooterCensus, displayStaffAttending, scrollRate, scrollValue, scrollDirection, facilityCode, isFromKiosk, ajaxRefreshCount) {
    this.DivisionExtension = divisionId;
    this.SplitScreen = splitScreen;
    this.DisplayPTCode = displayPTCode;
    this.GenderColorCode = genderColorCode;
    this.SortBySelected = sortBy;
    this.DisplayFooterCensus = displayFooterCensus;
    this.DisplayStaffAttendingSelected = displayStaffAttending;
    this.ScrollRateSelected = scrollRate;
    this.ActualScrollValue = scrollValue;
    this.ActualScrollDirection = scrollDirection;
    this.FacilityCode = facilityCode;
    this.IsFromWhiteboardKiosk = isFromKiosk;
    this.AjaxRefreshCount = ajaxRefreshCount;
}

function autoScroll() {
    var div = $('.tablescroll_wrapper');
    var tbl = $('.tablescroll_body');
    var scrollDirection = $('#ActualScrollDirection').val();
    var scroll;
    for (i = 0; i < div.length; i++) {        
        if ($(div)[i].scrollHeight - $(div[i]).scrollTop() == $(div[i]).outerHeight()-2) {
            scroll = $(div[i]).scrollTop() - ($(div[i]).height() - 10); //up
            scrollDirection = '0';
        }
        else if ($(div[i]).scrollTop() == 0) {
            scroll = $(div[i]).scrollTop() + ($(div[i]).height() - 10); //down
            scrollDirection = '1';
        }
        else {
            if (scrollDirection == '1')
                scroll = $(div[i]).scrollTop() + ($(div[i]).height() - 10); //down
            else
                scroll = $(div[i]).scrollTop() - ($(div[i]).height() - 10); //up
        }
        $(div[i]).animate({ scrollTop: scroll }, 1500);
        $('#ActualScrollDirection').val(scrollDirection);
        $('#ActualScrollValue').val(scroll);
    }
}

var EditStaffViewModel = function (bedId, staff, patientId) {
    this.BedId = bedId;
    this.Staff = staff;
    this.PatientId = patientId;
}

function SortingFunctionality() {
    var initialSort = -1; var initialSortDirection = 0;
    var defaultSort = $('#SortBySelected').val();
    if (defaultSort == 'Staff/Attending (ascending)') {
        initialSort = 4;
        initialSortDirection = 0;
    }
    else if (defaultSort == 'Staff/Attending (descending)') {
        initialSort = 4;
        initialSortDirection = 1;
    }
    else if (defaultSort == 'Ward (ascending)') {
        if ($('#DisplayStaffAttendingSelected').val() == 'Staff and Attending')
            initialSort = 9;
        else
            initialSort = 8;
        initialSortDirection = 0;
    }
    else if (defaultSort == 'Ward (descending)') {
        if ($('#DisplayStaffAttendingSelected').val() == 'Staff and Attending')
            initialSort = 9;
        else
            initialSort = 8;
        initialSortDirection = 1;
    }

    if (parseInt($('#ScrollRateSelected').val()) > 0) {
        var tblHeads = $('.tablescroll_head');
        var tblBodies = $('.tablescroll_body');
        var headThTags; var bodyThTags;

        if (initialSort >= 0) {
            for (k = 0; k < tblHeads.length; k++) {
                var th = $(tblHeads[k]).find('th');
                if (initialSortDirection == 0)
                    $(th[initialSort]).attr('class', 'header headerSortDown');
                else
                    $(th[initialSort]).attr('class', 'header headerSortUp');
            }
        }
        $('.tablescroll_body').tablesorter({
            sortList: [[initialSort, initialSortDirection]],
            widgets: ['zebra'],
            textExtraction: function (node) {
                var imgs = $(node).find('img');
                var links = $(node).find('a');
                var divs = $(node).find('div');
                if (imgs.length == 1)
                    return $(imgs[0]).attr('title');
                else if (links.length == 1)
                    return $(links[0]).text();
                else if (divs.length == 2) {
                    if ($(divs[0]).css('display') == 'block')
                        return $(divs[0]).find('label').text();
                    else
                        return $(divs[0]).find('input').val();
                }
                else
                    return node.innerHTML;
            }
        });

        for (b = 0; b < tblHeads.length; b++) {
            headThTags = $(tblHeads[b]).find('th');
            bodyThTags = $(tblBodies[b]).find('th');
            for (c = 0; c < headThTags.length; c++) {
                if ($(headThTags[c]).text() != "COMMENTS")                     
                    $(headThTags[c]).click({ sortCol: $(bodyThTags[c]), sortTable: $(tblBodies[b]), roxIndex: c, sortColMain: $(headThTags[c]), sortThTags: headThTags }, clickSort);                
            }
        }
    }
    else {
        if ($('#DisplayStaffAttendingSelected').val() == 'Staff and Attending') {
            $('table[name=tblWhiteboard]').tablesorter({
                sortList: [[initialSort, initialSortDirection]],
                headers: { 6: { sorter: false} },
                widgets: ['zebra'],
                textExtraction: function (node) {
                    var imgs = $(node).find('img');
                    var links = $(node).find('a');
                    var divs = $(node).find('div');
                    if (imgs.length == 1)
                        return $(imgs[0]).attr('title');
                    else if (links.length == 1)
                        return $(links[0]).text();
                    else if (divs.length == 2) {
                        if ($(divs[0]).css('display') == 'block')
                            return $(divs[0]).find('label').text();
                        else
                            return $(divs[0]).find('input').val();
                    }
                    else
                        return node.innerHTML;
                }
            });
        }
        else {
            $('table[name=tblWhiteboard]').tablesorter({
                sortList: [[initialSort, initialSortDirection]],
                headers: { 5: { sorter: false} },
                widgets: ['zebra'],
                textExtraction: function (node) {
                    var imgs = $(node).find('img');
                    var links = $(node).find('a');
                    var divs = $(node).find('div');
                    if (imgs.length == 1)
                        return $(imgs[0]).attr('title');
                    else if (links.length == 1)
                        return $(links[0]).text();
                    else if (divs.length == 2) {
                        if ($(divs[0]).css('display') == 'block')
                            return $(divs[0]).find('label').text();
                        else
                            return $(divs[0]).find('input').val();
                    }
                    else
                        return node.innerHTML;
                }
            });
        }
    }
}

function clickSort(event) {    
    $(event.data.sortThTags).each(function () { $(this).attr('class', 'header'); });
    var direction;
    if ($(event.data.sortCol).hasClass('header headerSortDown')) {
        direction = 1;
        $(event.data.sortColMain).attr('class', 'header headerSortUp');
    }
    else {
        direction = 0;
        $(event.data.sortColMain).attr('class', 'header headerSortDown');
    }
    var sorting = [[event.data.roxIndex, direction]];
    $(event.data.sortTable).trigger("sorton", [sorting]);
}

function ButtonsManageStaff() {
    $('a[id^="btnSaveStaff_"]').click(
        function () {
            var index = $(this).attr('id').split('_')[1];
            var jsStaff = new EditStaffViewModel($('#hiddenBedId_' + index + '').val(), $('#textboxStaff_' + index + '').val().toUpperCase(), $('#hiddenPatientId_' + index + '').val());
            var jsonText = JSON.stringify(jsStaff);
            var token = $.getAntiForgeryToken();
            $.ajax({
                type: "POST",
                url: "WardWhiteBoardStaff",                
                dataType: "json",                
                data: { __RequestVerificationToken: token.value, model: jsonText },
                async: true,
                cache: false,
                success: function (msg) {
                    $('#lblStaff_' + index + '').text(msg);
                    $('#divStaffEdit_' + index + '').css('display', 'none');
                    $('#divStaffReadOnly_' + index + '').css('display', 'block');
                },
                error: function (x, e) {
                    if (x.responseText.indexOf('<title>BMS User Login Page</title>') >= 0)
                        window.location = '@Url.Action("LogOn", "Account")';
                    else if (x.responseText.indexOf('<title>Unhandled Exception</title>') >= 0 || x.responseText.indexOf('<title>Unauthorized</title>') >= 0)
                        document.body.innerHTML = x.responseText;
                }
            });
            return false;
        });
    $('a[id^="btnCancelStaff_"]').click(
        function () {
            var index = $(this).attr('id').split('_')[1];
            $('#divStaffEdit_' + index + '').css('display', 'none');
            $('#divStaffReadOnly_' + index + '').css('display', 'block');
            return false;
        });
    $('div[id^="divStaffReadOnly_"]').click(
        function () {
            var index = $(this).attr('id').split('_')[1];
            var count = $('div[id^="divStaffReadOnly_"]').length;
            for (i = 0; i < count; i++) {
                $('#divStaffEdit_' + i + '').css('display', 'none');
                $('#divStaffReadOnly_' + i + '').css('display', 'block');
            }
            $('#textboxStaff_' + index + '').val($('#lblStaff_' + index + '').text());
            $('#divStaffEdit_' + index + '').css('display', 'block');
            $('#divStaffReadOnly_' + index + '').css('display', 'none');
            return false;
        });
}