﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using Microsoft.Reporting.WebForms;
using BMS.Web.App_GlobalResource;
using BMS.Facade;
using BMS.Utils;
using BMS.Web.Reporting;
using BMS.Facade.Data;
using BMS.ServicesWrapper.Security;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Reports
{
    /// <summary>
    /// Page responsible for calling the Report Viewer with the appropriate credentials and parameters
    /// </summary>
    public partial class ReportViewer : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                facilityHomeLink.Text = Strings.BMS_Home;
                iconsHomeLink.Text = Strings.IconLegend;
                informationHomeLink.Text = Strings.Information;
                homeLink.Text = BMS.Web.App_GlobalResource.Strings.ReturnToMainPage;
                homeLink.NavigateUrl = "~";

                if (Request == null || Request.QueryString == null || Request.QueryString.Count == 0)
                    return;

                String token = Request.QueryString[0];
                if (String.IsNullOrEmpty(token))
                    return;

                ReportUtil reportUtil = ReportUtil.Decrypt(token);

                string returnUrl = reportUtil.Parameters[Constants.REP_GENERAL_RETURN_PATH];
                string returnText = System.Web.HttpContext.Current.Server.UrlDecode(reportUtil.Parameters[Constants.REP_GENERAL_RETURN_TEXT]);
                string reportTitle = System.Web.HttpContext.Current.Server.UrlDecode(reportUtil.Parameters[Constants.REPORT_TITLE]);

                if (!string.IsNullOrEmpty(returnUrl))
                    homeLink.NavigateUrl = returnUrl;
                else
                    homeLink.Visible = false;
                if (!string.IsNullOrEmpty(returnText))
                    homeLink.Text = returnText;
                else
                    homeLink.Visible = false;
                if (!string.IsNullOrEmpty(reportTitle))
                {
                    AntiXssEncoder xss = new AntiXssEncoder();
                    reportName.InnerText = xss.Decode(reportTitle);
                }

                ReportViewerControl.ServerReport.ReportServerUrl = new Uri(reportUtil.ReportServerUrl);
                ReportViewerControl.ServerReport.ReportPath = reportUtil.ReportPath;

                if (reportUtil.ReportName == Constants.SignedAdmission || reportUtil.ReportName == Constants.SignedDischarge || reportUtil.ReportName == Constants.AnticipatedDischarge
                    || reportUtil.ReportName == Constants.DischargeAppointment1 || reportUtil.ReportName == Constants.EMSBedStatus || reportUtil.ReportName == Constants.ACTIVE_TRANSFER_REPORT)
                {
                    string domainId = SecurityFactory.Instance.GetCurrentDomain();
                    List<Module> flags = FacadeManager.ConfigurationInterface.GetModules(domainId, new II(domainId, reportUtil.Parameters[Constants.REP_GENERAL_FACILITY_EXTENSION])).ToList();
                    switch (reportUtil.ReportName)
                    {
                        case Constants.SignedAdmission:
                            if (flags.Where(a => a.Code.Equals(Constants.ADM_ORD, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                txtInactive.InnerHtml = "The Admission Orders Module is currently inactivated.";
                                ReportViewerControl.Visible = false;
                            }
                            break;
                        case Constants.SignedDischarge:
                            if (flags.Where(a => a.Code.Equals(Constants.DISCH_ORD, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                txtInactive.InnerHtml = "The Discharge Orders Module is currently inactivated.";
                                ReportViewerControl.Visible = false;
                            }
                            break;
                        case Constants.AnticipatedDischarge:
                            if (flags.Where(a => a.Code.Equals(Constants.ANTIC_DISCH, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                txtInactive.InnerHtml = "The Anticipated Discharge Orders Module is currently inactivated.";
                                ReportViewerControl.Visible = false;
                            }
                            break;                                                
                        case Constants.DischargeAppointment1:
                            if (flags.Where(a => a.Code.Equals(Constants.DISCHARGE_APPOINTMENT, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                txtInactive.InnerHtml = "The Discharge Appointment Module is currently inactivated.";
                                ReportViewerControl.Visible = false;
                            }
                            break;                        
                        case Constants.EMSBedStatus:
                            if (flags.Where(a => a.Code.Equals(Constants.EMS_MODULE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                txtInactive.InnerHtml = "The EMS Bed Cleaning Module is currently inactivated.";
                                ReportViewerControl.Visible = false;
                            }
                            break;                        
                        case Constants.ACTIVE_TRANSFER_REPORT:
                            if (flags.Where(a => a.Code.Equals(Constants.TRSF_ORD, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault().CurrentlyInUse.code.Equals(Constants.No, StringComparison.InvariantCultureIgnoreCase))
                            {
                                txtInactive.InnerHtml = "The Transfer Orders Module is currently inactivated.";
                                ReportViewerControl.Visible = false;
                            }
                            break;
                        default:
                            txtInactive.InnerHtml = string.Empty;
                            ReportViewerControl.Visible = true;
                            break;
                    }
                }
                if (!string.IsNullOrEmpty(txtInactive.InnerHtml))
                    return;

                if (this.IsPostBack)
                {
                    if (reportTitle == Constants.ICON_FLAG_RPT)
                    {

                        ReportParameterInfoCollection collPostBack = null;
                        collPostBack = ReportViewerControl.ServerReport.GetParameters();
                        ReportParameterInfo selectedIcon = collPostBack.FirstOrDefault(p => string.Equals(p.Name, Constants.ICON_FLAG_RPT_SELECT_RPT_PARAM, StringComparison.InvariantCultureIgnoreCase));
                        if (selectedIcon != null)
                        {
                            if (selectedIcon.Values.Count > 0)
                            {
                                string selectedIconName = selectedIcon.ValidValues.Where(a => a.Value == selectedIcon.Values[0]).Select(a => a.Label).FirstOrDefault();
                                if (!string.IsNullOrWhiteSpace(selectedIconName))
                                    ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "key", "ResizeFormPostBack('" + selectedIconName + " Report');", true);
                            }
                        }


                    }
                    else
                        ScriptManager.RegisterClientScriptBlock(this, this.GetType(), "key", "ResizeForm();", true);
                }
                else
                {

                    ReportViewerControl.ServerReport.ReportServerCredentials =
                        (
                        String.IsNullOrEmpty(reportUtil.Domain) ?
                        new CustomReportCredentials(reportUtil.UserName, reportUtil.Password) :
                        new CustomReportCredentials(reportUtil.UserName, reportUtil.Password, reportUtil.Domain)
                    );

                    List<ReportParameter> param = new List<ReportParameter>();

                    ReportParameterInfoCollection coll = null;

                    try
                    {
                        coll = ReportViewerControl.ServerReport.GetParameters();
                        if (coll.FirstOrDefault(p => string.Equals(p.Name, Strings.UserID, StringComparison.InvariantCultureIgnoreCase)) != null)
                            param.Add(new ReportParameter(Strings.UserID, reportUtil.UserId, false));

                        foreach (var paramName in reportUtil.Parameters.Keys)
                            if (coll.FirstOrDefault(p => string.Equals(p.Name, paramName, StringComparison.InvariantCultureIgnoreCase)) != null)
                                param.Add(new ReportParameter(paramName, reportUtil.Parameters[paramName], true));

                        //adds all the parameter values passed through the query string, excepting UserID and ApplicationURL that are treated separately above and below.
                        foreach (ReportParameterInfo paramName in coll)
                            if (coll.FirstOrDefault(p => string.Equals(p.Name, paramName.Name, StringComparison.InvariantCultureIgnoreCase)) != null)
                            {
                                if (Request.QueryString[paramName.Name] != null)
                                    param.Add(new ReportParameter(paramName.Name, Request.QueryString[paramName.Name], true));
                            }

                        if (coll.FirstOrDefault(p => string.Equals(p.Name, Strings.ApplicationURL, StringComparison.InvariantCultureIgnoreCase)) != null)
                        {
                            string url = HttpContext.Current.Request.Url.ToString();
                            int rpt = url.IndexOf("/" + Strings.ReportsFolder);
                            if (rpt > -1)
                            {
                                url = url.Substring(0, rpt);
                                param.Add(new ReportParameter(Strings.ApplicationURL, url, false));
                            }
                        }


                        ReportViewerControl.ServerReport.SetParameters(param);
                        //ReportViewerControl.Height = 1000;
                        //ReportViewerControl.ZoomMode = ZoomMode.Percent;
                        //ReportViewerControl.ZoomPercent = 225;
                    }
                    catch (Microsoft.Reporting.WebForms.ReportServerException rsException)
                    {
                        OnError(rsException.ErrorCode + "\t" + rsException.Message);
                    }

                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected void OnError(String message)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Session[Constants.REPORTS_ERROR_MESSAGE_SESSION_KEY] = message;
                Response.Redirect("ReportError.aspx");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected void ReportViewerControl_ReportError(object sender, ReportErrorEventArgs e)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (e.Exception != null &&
                    e.Exception.InnerException != null &&
                    e.Exception.InnerException.InnerException != null)
                {
                    e.Handled = true;
                    OnError(e.Exception.InnerException.InnerException.Message);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
