﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using InfoWorld.EVS.CTSMAPI;
using BMS.Web.App_GlobalResource;
using BMS.Utils;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// Edit Whiteboard Room Model class.
    /// </summary>
    public class WhiteboardRoomViewModel : BaseViewModel
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the name of the ward.
        /// </summary>
        /// <value>
        /// The name of the ward.
        /// </value>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the reasons.
        /// </summary>
        /// <value>
        /// The reasons.
        /// </value>
        public CDList ReasonList { get; set; }

        /// <summary>
        /// Gets or sets the bed.
        /// </summary>
        /// <value>
        /// The bed.
        /// </value>
        public Bed Bed { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [ValidateXss]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets the selected reason.
        /// </summary>
        /// <value>
        /// The selected reason.
        /// </value>
        public string SelectedReason { get; set; }

        /// <summary>
        /// Gets or sets the ward list.
        /// </summary>
        /// <value>
        /// The ward list.
        /// </value>
        public IList<Ward> WardList { get; set; }

        /// <summary>
        /// Gets or sets the ward group list.
        /// </summary>
        /// <value>
        /// The ward group list.
        /// </value>
        public IList<Division> WardGroupList { get; set; }

        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        public string Ward { get; set; }

        /// <summary>
        /// Gets or sets the cleaning date.
        /// </summary>
        /// <value>
        /// The cleaning date.
        /// </value>
        public DateTime CleaningDate { get; set; }

        public string CleaningDateString
        {
            get { return CleaningDate.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        CleaningDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        CleaningDate = DateTime.Today;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the expected completed date.
        /// </summary>
        /// <value>
        /// The expected completed date.
        /// </value>
        public DateTime? ExpectedCompletedDate { get; set; }

        public string ExpectedCompletedDateString
        {
            get
            {
                if (ExpectedCompletedDate.HasValue)
                    return ExpectedCompletedDate.Value.ToString(Strings.USDate);
                else
                    return string.Empty;
            }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        ExpectedCompletedDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        ExpectedCompletedDate = null;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the expected completed date hour selected.
        /// </summary>
        /// <value>
        /// The expected completed date hour selected.
        /// </value>
        public string ExpectedCompletedDateHourSelected { get; set; }

        /// <summary>
        /// Gets or sets the expected completed date minute selected.
        /// </summary>
        /// <value>
        /// The expected completed date minute selected.
        /// </value>
        public string ExpectedCompletedDateMinuteSelected { get; set; }

        /// <summary>
        /// Gets or sets the real division selected extension.
        /// </summary>
        /// <value>
        /// The real division selected extension.
        /// </value>
        public string RealDivisionSelectedExtension { get; set; }

        /// <summary>
        /// Gets or sets the real division selected root.
        /// </summary>
        /// <value>
        /// The real division selected root.
        /// </value>
        public string RealDivisionSelectedRoot { get; set; }

        /// <summary>
        /// Gets or sets the root bed id.
        /// </summary>
        /// <value>
        /// The root bed id.
        /// </value>
        public string RootBedId { get; set; }

        /// <summary>
        /// Gets or sets the extension bed id.
        /// </summary>
        /// <value>
        /// The extension bed id.
        /// </value>
        public string ExtensionBedId { get; set; }

        /// <summary>
        /// Gets or sets the flags list.
        /// </summary>
        /// <value>
        /// The flags list.
        /// </value>
        public CDList FlagsList { get; set; }

        /// <summary>
        /// Gets or sets the nurse assignment.
        /// </summary>
        /// <value>
        /// The nurse assignment.
        /// </value>
        [ValidateXss]
        public string NurAssignment { get; set; }

        /// <summary>
        /// Gets or sets the PT risk flags.
        /// </summary>
        /// <value>
        /// The PT risk flags.
        /// </value>
        public string PTRiskFlags { get; set; }

        /// <summary>
        /// Gets or sets the hour selected.
        /// </summary>
        /// <value>
        /// The hour selected.
        /// </value>
        public string HourSelected { get; set; }

        /// <summary>
        /// Gets or sets the minute selected.
        /// </summary>
        /// <value>
        /// The minute selected.
        /// </value>
        public string MinuteSelected { get; set; }

        /// <summary>
        /// Gets or sets the vista ward.
        /// </summary>
        /// <value>
        /// The vista ward.
        /// </value>
        public string VistaWard { get; set; }

        /// <summary>
        /// Gets or sets the request cleaning.
        /// </summary>
        /// <value>
        /// The request cleaning.
        /// </value>
        public string RequestCleaning { get; set; }

        /// <summary>
        /// Gets or sets the unavailable reason code.
        /// </summary>
        /// <value>
        /// The unavailable reason code.
        /// </value>
        public string UnavailableReasonCode { get; set; }

        /// <summary>
        /// Gets or sets the submit button.
        /// </summary>
        /// <value>
        /// The submit button.
        /// </value>
        public string SubmitButton { get; set; }

        /// <summary>
        /// Gets or sets the never mind button.
        /// </summary>
        /// <value>
        /// The never mind button.
        /// </value>
        public string NeverMindButton { get; set; }

        /// <summary>
        /// Gets or sets the clear all button.
        /// </summary>
        /// <value>
        /// The clear all button.
        /// </value>
        public string ClearAllButton { get; set; }

        /// <summary>
        /// Gets or sets the ward from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The ward parameter.
        /// </value>
        public string WardParameter { get; set; }

        /// <summary>
        /// Gets or sets the split screen from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The split screen parameter.
        /// </value>
        public string SplitScreenParameter { get; set; }

        /// <summary>
        /// Gets or sets the display PT from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The display PT code parameter.
        /// </value>
        public string DisplayPTCodeParameter { get; set; }

        /// <summary>
        /// Gets or sets the gender color from ward whiteboard home page.
        /// </summary>
        /// <value>
        /// The gender color code parameter.
        /// </value>
        public string GenderColorCodeParameter { get; set; }

        /// <summary>
        /// Gets or sets the bed unavailable history.
        /// </summary>
        /// <value>
        /// The bed unavailable history.
        /// </value>
        public BedUnavailableHistory BedUnavailableHistory { get; set; }

        /// <summary>
        /// Gets or sets the set visibility for extected completed date.
        /// </summary>
        /// <value>
        /// The set visibility for extected completed date.
        /// </value>
        public string SetVisibilityForExpectedOrActualCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is expected completed date visible.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is expected completed date visible; otherwise, <c>false</c>.
        /// </value>
        public bool IsExpectedCompletedDateVisible { get; set; }

        /// <summary>
        /// Gets or sets the sort by parameter.
        /// </summary>
        /// <value>
        /// The sort by parameter.
        /// </value>
        public string SortByParameter { get; set; }

        /// <summary>
        /// Gets or sets the display staff attending parameter.
        /// </summary>
        /// <value>
        /// The display staff attending parameter.
        /// </value>
        public string DisplayStaffAttendingParameter { get; set; }

        /// <summary>
        /// Gets or sets the root patient id.
        /// </summary>
        /// <value>
        /// The root patient id.
        /// </value>
        public string RootPatientId { get; set; }

        /// <summary>
        /// Gets or sets the extension patient id.
        /// </summary>
        /// <value>
        /// The extension patient id.
        /// </value>
        public string ExtensionPatientId { get; set; }

        /// <summary>
        /// Gets or sets the icons.
        /// </summary>
        /// <value>
        /// The icons.
        /// </value>
        public Dictionary<string, List<IconAssociationInfo>> IconsAssociationList
        {
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    StandardIconAssociationList = new List<IconAssociationInfo>();
                    EmergencyIconAssociationList = new List<IconAssociationInfo>();
                    SiteConfigurationIconAssociationList = new List<IconAssociationInfo>();
                    // generate the extended icon association list.
                    if (value != null)
                    {

                        IconCount = 0;
                        foreach (string key in value.Keys)
                        {
                            switch (key)
                            {
                                case Constants.STANDARD_ICON:
                                    StandardIconAssociationList = value[key];
                                    break;
                                case Constants.EMERGENCY_ICON:
                                    EmergencyIconAssociationList = value[key];
                                    break;
                                case Constants.SITE_CONFIGURABLE_ICON:
                                    SiteConfigurationIconAssociationList = value[key];
                                    break;
                            }
                        }

                        IconCount = StandardIconAssociationList.Count;

                        if (IconCount < EmergencyIconAssociationList.Count)
                            IconCount = EmergencyIconAssociationList.Count;
                        if (IconCount < SiteConfigurationIconAssociationList.Count)
                            IconCount = SiteConfigurationIconAssociationList.Count;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the standard icon association list.
        /// </summary>
        /// <value>
        /// The standard icon association list.
        /// </value>
        public IList<IconAssociationInfo> StandardIconAssociationList { get; set; }
        /// <summary>
        /// Gets or sets the emergency icon association list.
        /// </summary>
        /// <value>
        /// The emergency icon association list.
        /// </value>
        public IList<IconAssociationInfo> EmergencyIconAssociationList { get; set; }
        /// <summary>
        /// Gets or sets the site configuration icon association list.
        /// </summary>
        /// <value>
        /// The site configuration icon association list.
        /// </value>
        public IList<IconAssociationInfo> SiteConfigurationIconAssociationList { get; set; }

        public int IconCount { get; set; }

        /// <summary>
        /// Gets or sets the display footer censusvalue for the whiteboard page.
        /// </summary>
        /// <value>
        /// The display footer census value.
        /// </value>
        public string DisplayFooterCensus { get; set; }

        /// <summary>
        /// Gets or sets the actual completed date.
        /// </summary>
        /// <value>
        /// The actual completed date.
        /// </value>
        public DateTime ActualCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the actual completed date string.
        /// </summary>
        /// <value>
        /// The actual completed date string.
        /// </value>
        public string ActualCompletedDateString
        {
            get { return ActualCompletedDate.ToString(Strings.USDate); }
            set
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    try
                    {
                        ActualCompletedDate = DateTime.Parse(value);
                    }
                    catch
                    {
                        ActualCompletedDate = DateTime.Today;
                    }
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the actual completed date hour selected.
        /// </summary>
        /// <value>
        /// The actual completed date hour selected.
        /// </value>
        public string ActualCompletedDateHourSelected { get; set; }

        /// <summary>
        /// Gets or sets the actual completed date minute selected.
        /// </summary>
        /// <value>
        /// The actual completed date minute selected.
        /// </value>
        public string ActualCompletedDateMinuteSelected { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is actual completed date visible.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is actual completed date visible; otherwise, <c>false</c>.
        /// </value>
        public bool IsActualCompletedDateVisible { get; set; }

        /// <summary>
        /// Gets or sets the scroll rate parameter.
        /// </summary>
        /// <value>
        /// The scroll rate parameter.
        /// </value>
        public int ScrollRateParameter { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is evacuation facility.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is evacuation facility; otherwise, <c>false</c>.
        /// </value>
        public bool IsEvacuationFacility { get; set; }

        /// <summary>
        /// Gets or sets the flow id.
        /// </summary>
        /// <value>
        /// The flow id.
        /// </value>
        public Guid? FlowId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has evacuation icon.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has evacuation icon; otherwise, <c>false</c>.
        /// </value>
        public bool HasEvacuationIcon { get; set; }

        /// <summary>
        /// Gets or sets the special instructions.
        /// </summary>
        /// <value>
        /// The special instructions.
        /// </value>
        [ValidateXss]
        public string SpecialInstructions { get; set; }

        /// <summary>
        /// Gets or sets the bed clean.
        /// </summary>
        /// <value>
        /// The bed clean.
        /// </value>
        public BedClean BedClean { get; set; }

        /// <summary>
        /// Gets or sets the EMS notify icon.
        /// </summary>
        /// <value>
        /// The EMS notify icon.
        /// </value>
        public IconInfo EMSNotifyIcon { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed clean requested.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed clean requested; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedCleanRequested { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed clean accepted.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed clean accepted; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedCleanAccepted { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is bed clean completed.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is bed clean completed; otherwise, <c>false</c>.
        /// </value>
        public bool IsBedCleanCompleted { get; set; }

        /// <summary>
        /// Gets or sets the bed staff history list.
        /// </summary>
        /// <value>
        /// The bed staff history list.
        /// </value>
        public List<BedStaffHistory> BedStaffHistoryList { get; set; }

        /// <summary>
        /// Gets or sets the facility time zone.
        /// </summary>
        /// <value>
        /// The facility time zone.
        /// </value>
        public string FacilityTimeZone { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [EMS module inactive].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [EMS module inactive]; otherwise, <c>false</c>.
        /// </value>
        public bool EMSModuleInactive { get; set; }

        /// <summary>
        /// Gets or sets the display EMS module inactive.
        /// </summary>
        /// <value>
        /// The display EMS module inactive.
        /// </value>
        public string DisplayEMSModuleInactive { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is selected reason available.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is selected reason available; otherwise, <c>false</c>.
        /// </value>
        public bool IsSelectedReasonAvailable { get; set; }

        #endregion
    }
}
