﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using System.Web.Mvc;
using System.ComponentModel.DataAnnotations;
using BMS.Utils;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Models
{
    /// <summary>
    /// Event Notification View Model class.
    /// </summary>
    public class EventNotificationViewModel : BaseViewModel
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the ward group list.
        /// </summary>
        /// <value>
        /// The ward group list.
        /// </value>
        public IList<Division> WardGroupList { get; set; }

        /// <summary>
        /// Gets or sets the ward group object selected.
        /// </summary>
        /// <value>
        /// The ward group object selected.
        /// </value>
        public string WardGroupSelected { get; set; }

        /// <summary>
        /// Gets or sets the ward group name selected.
        /// </summary>
        /// <value>
        /// The ward group name selected.
        /// </value>
        public string WardGroupNameSelected { get; set; }

        /// <summary>
        /// Gets or sets the current events.
        /// </summary>
        /// <value>
        /// The current events.
        /// </value>
        public IList<EventNotification> CurrentEventsList { get; set; }

        /// <summary>
        /// Gets or sets the currents events list extented.
        /// </summary>
        /// <value>
        /// The currents events list extented.
        /// </value>
        public IList<DisplayCurrentEvent> CurrentsEventsListExtented { get; set; }

        /// <summary>
        /// Gets or sets the flags list.
        /// </summary>
        /// <value>
        /// The flags list.
        /// </value>
        public CDList FlagsList { get; set; }

        /// <summary>
        /// Gets or sets the admission order.
        /// </summary>
        /// <value>
        /// The admission order.
        /// </value>
        public EventNotificationItem AdmissionOrder { get; set; }

        /// <summary>
        /// Gets or sets the anticipated discharge.
        /// </summary>
        /// <value>
        /// The anticipated discharge.
        /// </value>
        public EventNotificationItem AnticipatedDischarge { get; set; }

        /// <summary>
        /// Gets or sets the discharge appointment order.
        /// </summary>
        /// <value>
        /// The discharge appointment order.
        /// </value>
        public EventNotificationItem DischargeAppointmentOrder { get; set; }

        /// <summary>
        /// Gets or sets the discharge order.
        /// </summary>
        /// <value>
        /// The discharge order.
        /// </value>
        public EventNotificationItem DischargeOrder { get; set; }

        /// <summary>
        /// Gets or sets the transfer order.
        /// </summary>
        /// <value>
        /// The transfer order.
        /// </value>
        public EventNotificationItem TransferOrder { get; set; }

        /// <summary>
        /// Gets or sets the bed OOS.
        /// </summary>
        /// <value>
        /// The bed OOS.
        /// </value>
        public EventNotificationItem BedOOS { get; set; }

        /// <summary>
        /// Gets or sets the bed switch.
        /// </summary>
        /// <value>
        /// The bed switch.
        /// </value>
        public EventNotificationItem BedSwitch { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is add operation.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is add operation; otherwise, <c>false</c>.
        /// </value>
        public bool IsAddOperation { get; set; }

        /// <summary>
        /// Gets or sets the header.
        /// </summary>
        /// <value>
        /// The header.
        /// </value>
        public string Header { get; set; }

        /// <summary>
        /// Gets or sets the event already exists display.
        /// </summary>
        /// <value>
        /// The event already exists display.
        /// </value>
        public string EventAlreadyExistsDisplay { get; set; }

        /// <summary>
        /// Gets or sets the event add edit display.
        /// </summary>
        /// <value>
        /// The event add edit display.
        /// </value>
        public string EventAddEditDisplay { get; set; }

        #endregion
    }

    /// <summary>
    /// Display existing event.
    /// </summary>
    public class DisplayCurrentEvent
    {
        public string WardGroup { get; set; }
        public string WardGroupExtension { get; set; }
        public string AdmissionOrder { get; set; }
        public string AnticipatedDischarge { get; set; }
        public string DischargeAppointmentOrder { get; set; }
        public string DischargeOrder { get; set; }
        public string TransferOrder { get; set; }
        public string BedOOS { get; set; }
        public string BedSwitch { get; set; }
    }

    /// <summary>
    /// Event Notification Item class.
    /// </summary>
    public class EventNotificationItem
    {
        /// <summary>
        /// Gets or sets the bed controller email.
        /// </summary>
        /// <value>
        /// The bed controller email.
        /// </value>
        [StringLength(Constants.MAX_BED_CONTROLLER_EMAIL_LENGTH, ErrorMessage = "Addresses string too long. The total number of characters allowed is 300 per text box with no spaces...")]
        [RegularExpression(Constants.EMAIL_GROUP_REGULAR_EXPRESSION, ErrorMessage = "Invalid email.")]
        public string BedControllerEmail { get; set; }

        /// <summary>
        /// Gets or sets the other email.
        /// </summary>
        /// <value>
        /// The other email.
        /// </value>
        //[StringLength(Constants.MAX_BED_CONTROLLER_EMAIL_LENGTH, ErrorMessage = "Addresses string too long. The total number of characters allowed is 150 per text box with no spaces...")]
        //[RegularExpression(Constants.EMAIL_GROUP_REGULAR_EXPRESSION, ErrorMessage = "Invalid email.")]
        //public string OtherEmail { get; set; }

        /// <summary>
        /// Gets or sets the bed controller notify.
        /// </summary>
        /// <value>
        /// The bed controller notify.
        /// </value>
        public CD BedControllerNotify { get; set; }

        /// <summary>
        /// Gets or sets the other notify.
        /// </summary>
        /// <value>
        /// The other notify.
        /// </value>
        //public CD OtherNotify { get; set; }

    }
}