﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;

namespace BMS.Web.Models
{
    /// <summary>
    /// Bed Board Module Model class.
    /// </summary>
    public class BedBoardModuleViewModel : BaseViewModel
    {
        #region Public Members
        /// <summary>
        /// Gets or sets the bed board module.
        /// </summary>
        /// <value>
        /// The bed board module.
        /// </value>
        public string BedBoardModule { get; set; }

        /// <summary>
        /// Gets or sets the module list.
        /// </summary>
        /// <value>
        /// The module list.
        /// </value>
        public CDList ModuleList { get; set; }

        /// <summary>
        /// Gets or sets the flags list.
        /// </summary>
        /// <value>
        /// The flags list.
        /// </value>
        public CDList FlagsList { get; set; }

        /// <summary>
        /// Gets or sets the place in use.
        /// </summary>
        /// <value>
        /// The place in use.
        /// </value>
        public CD PlaceInUse { get; set; }

        /// <summary>
        /// Gets or sets the application module list.
        /// </summary>
        /// <value>
        /// The application module list.
        /// </value>
        public IList<Module> ApplicationModuleList { get; set; }
        #endregion
    }
}