﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.Security;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Utils;
using BMS.Facade.Data;
using BMS.Facade;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers.Shared;
using BMS.Facade.Fault;
using System.ServiceModel;
using BMS.Security.DurableIssuedToken;
using BMS.Authentication;
using BMS.Web.App_GlobalResource;
using System.Threading;

namespace BMS.Web.Controllers
{
    public class AccountController : Controller
    {
        [NoCacheAttribute]
        public ActionResult LogOn()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                LogOnModel model = new LogOnModel();
                return LogOn(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private bool IsUserLoggedIn()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return HttpContext.User.Identity.IsAuthenticated;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private ActionResult LogOn(LogOnModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ActionName("LogOn")]
        [MultiButtonAttribute]
        public ActionResult GoToHome(LogOnModel model, string returnUrl)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool successfullyLog = TryLogOn(model);
                if (successfullyLog)
                    return GetSuccessfullyLogOnAction(returnUrl);

                return LogOn(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ActionName("LogOn")]
        [MultiButtonAttribute]
        public ActionResult GoToBedCleaning(LogOnModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bool successfullyLog = TryLogOn(model);
                if (successfullyLog)
                {
                    User user = FacadeManager.UserInterface.GetProfile();
                    return this.RedirectToAction<EmsBedStatusAdminController>(act => act.Index(BaseController.EncryptQueryString(new string[] { "division", "startDate", "endDate", "returnLink", "divisionFromReport" }, new string[] { string.Empty, string.Empty, string.Empty, string.Empty, string.Empty }, user.Salt)));
                }
                return LogOn(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private bool TryLogOn(LogOnModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (IsUserLoggedIn())
                {
                    System.Web.SessionState.HttpSessionState currentSession = System.Web.HttpContext.Current.Session;
                    MvcApplication.SessionEnd(currentSession);
                    currentSession.Clear();
                    FormsAuthentication.SignOut();
                }
                ValidateUser(model);
                if (ModelState.IsValid)
                    return true;
                // If we got this far, something failed, redisplay form
                FormsAuthentication.SignOut();
                System.Web.HttpContext.Current.Session.Abandon();
                return false;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private ActionResult GetSuccessfullyLogOnAction(string returnUrl)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (Url.IsLocalUrl(returnUrl) && returnUrl.Length > 1 && returnUrl.StartsWith("/") && !returnUrl.StartsWith("//") && !returnUrl.StartsWith("/\\"))
                {
                    if (returnUrl.StartsWith("/Reports"))
                        return this.RedirectToAction<HomeController>(action => action.Index());
                    else
                        return Redirect(returnUrl);
                }
                else
                    return GetRedirectToByUserRole();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ActionResult GetRedirectToByUserRole()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                User user = FacadeManager.UserInterface.GetProfile();
                if (user.IsSuperUser || user.SupportUser.IsYes() || user.NationalUser.IsYes() || user.RegionalUser.IsYes())
                    return this.RedirectToAction<NationalAndRegionalController>(act => act.Index((string)null));

                if (user.SiteUser.IsYes() || user.VisnUser.IsYes())                
                    return this.RedirectToAction<HomeController>(act => act.Index());                
                if (user.AdminUser.IsYes())
                    return this.RedirectToAction<HomeController>(act => act.Index());
                if (user.EMSUser.IsYes() || user.EMSSupervisorUser.IsYes())
                    return this.RedirectToAction<EmsBedStatusAdminController>(act => act.Index(BaseController.EncryptQueryString(new string[] { "division", "startDate", "endDate", "returnLink", "divisionFromReport" }, new string[] { string.Empty, string.Empty, string.Empty, string.Empty, string.Empty }, user.Salt)));
                if (user.GuestUser.IsYes())
                {
                    IReportInfo nationalBedAvailabilityReport = Facade.FacadeManager.ReportsInterface.GetOtherReports().Where(a => a.Name == Constants.BED_AVAILABILITY_STATUS_REPORT).FirstOrDefault();
                    if (nationalBedAvailabilityReport.Parameters == null)
                        nationalBedAvailabilityReport.Parameters = new Dictionary<String, String>();
                 
                    DateTime dtUtc = DateTime.UtcNow;
                    DateTime dtTz = TimeZoneInfo.ConvertTimeFromUtc(dtUtc, FacadeUtil.GetFacilityTimeZoneInfo(user.Facility.Id));
                    nationalBedAvailabilityReport.Parameters.Add(Constants.REP_TIME_ZONE_MINUTES_OFFSET, dtTz.Subtract(dtUtc).TotalMinutes.ToString());

                    nationalBedAvailabilityReport.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, string.Empty);
                    nationalBedAvailabilityReport.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, string.Empty);
                    nationalBedAvailabilityReport.Parameters.Add(Constants.REPORT_TITLE, Strings.BedAvailabilityStatusReportTitle);
                    return Redirect(nationalBedAvailabilityReport.Url);
                }
                return this.RedirectToAction<HomeController>(act => act.Index());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void ValidateUser(LogOnModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (!ModelState.IsValid)
                    return;
                try
                {
                    if (Membership.ValidateUser(model.UserName, model.Password))
                    {
                        User user = FacadeManager.UserInterface.GetProfile();
                        model.FullUserName = user.UserName;
                        if (user.DefaultFacility == null)
                        {
                            if (user.IsSuperUser)
                            {
                                try
                                {
                                    IList<Facility> allFacilities = FacadeManager.EntityInterface.GetFacilitiesUsingWindowsAuthentication().Where(f => f.IsAlive == true).ToList();
                                    user.DefaultFacility = allFacilities.First();
                                }
                                catch (Exception e)
                                {
                                    ModelState.AddModelError("", "Can't get the facilities: " + e.Message);
                                }
                            }
                            else
                            {
                                ModelState.AddModelError("", "The user does not have a default facility. Please contact the administrator.");
                            }
                        }
                        if (user.DefaultFacility != null)
                        {
                            if (user.DefaultFacility.VistaSite.Visn == null)
                                user.DefaultFacility.VistaSite.Visn = FacadeManager.EntityInterface.GetVistaSite(user.DefaultFacility.VistaSite.Id).Visn;
                            FacadeManager.UserInterface.InsertLoggedUser(ProxyManager.GetCurrentSessionID2(), user.UserName, user.DefaultFacility, user.DefaultFacility.VistaSite.Visn);
                            if (!FacadeManager.UserInterface.CheckBMSReadPermission(user, user.DefaultFacility.Id))
                                ModelState.AddModelError(string.Empty, "The user name does not have permissions for the selected facility.");
                            else
                            {
                                FormsAuthentication.SetAuthCookie(model.UserName, model.RememberMe);
                                SetModelOnSuccessfullyLogOn(model);
                            }
                        }
                    }
                    else
                        ModelState.AddModelError("", "The user name or password provided is incorrect.");
                }
                catch (UserHasNoRoleException)
                {
                    ModelState.AddModelError(string.Empty, "The user does not have a role associated. Please contact the administrator.");
                }
                catch (Exception e)
                {
                    ModelState.AddModelError("", "There was an error when trying to login: " + e.Message);
                }

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }


        private void SetModelOnSuccessfullyLogOn(LogOnModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                User user = FacadeManager.UserInterface.GetProfile();
                user.Facility = user.DefaultFacility;
                if (user.VistaSite == null)
                    user.VistaSite = FacadeManager.EntityInterface.GetVistaSite(user.Facility.VistaSite.Id);
                user.Visn = user.VistaSite.Visn;
                user.Region = user.VistaSite.Visn.Region;

                if (user.Visn == null)
                {
                    ModelState.AddModelError("FacilityId", "The facility doesn't have an associated VISN.");
                    return;
                }               
                if (user.Region == null)
                {
                    ModelState.AddModelError("FacilityId", "The VISN on facility doesn't have an associated Region.");
                    return;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ActionResult LogOff()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                System.Web.HttpContext.Current.Session.Abandon();
                return View();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
