﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using BMS.VistaWorker2.Writer.Exceptions;

namespace BMS.VistaIntegration.Operations
{
    public class ParameterEventArgs : EventArgs
    {
        public class Info
        {
            public int ProcessedWithSuccesEntries { get; set; }
            public int ProcessedWithFaildEntries { get; set; }
        }

        public enum OperationState { Succeeded, PartiallySucceeded, Failed, Running }

        public Dictionary<string, Info> InfoDictionary { get; private set; }
        public Parameter Parameter { get; private set; }
        public int RetrievedEntries { get; set; }
        public OperationState State { get; set; }
        public string ErrorMessage { get; set; }
        public IList<WriterException> WriterExceptions { get; private set; }
        public int JobLogId { get; set; }
        public DateTime JobLogStartDate { get; set; }
        public int CompletedOperations { get; set; }

        public ParameterEventArgs(Parameter parameter)
        {
            this.Parameter = parameter;
            WriterExceptions = new List<WriterException>();
            InfoDictionary = new Dictionary<string, Info>();
        }


    }
}
