﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.Security;
using BMS.VistaIntegration.FacadeContracts;
using BMS.Facade;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using FacadeVistASite = BMS.VistaIntegration.FacadeContracts.VistASite;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Commands;
using BMS.Schedulers;
using System.Configuration;

namespace BMS.VistaIntegration.Dal.Schedulers
{
    public class SchedulerDal
    {
        private readonly string domain;
        private readonly ISessionFactory sessionFactory;

        public SchedulerDal(ISessionFactory sessionFactory)
        {
            this.sessionFactory = sessionFactory;
            domain = SecurityFactory.InstanceWindows.GetCurrentDomain();

        }


        private void OnVistASite(Dictionary<string, List<SchedulerData>> schedulersDicionary, FacadeVistASite site)
        {

            VistAConnectionInfo connectionInfo = ToConnectionInfo(site);
            AddSchedulerData(schedulersDicionary, site, connectionInfo, DataRetrievalMethod.MDWS);
            AddSchedulerData(schedulersDicionary, site, connectionInfo, DataRetrievalMethod.ODBC);

        }

        private void AddSchedulerData(
            Dictionary<string, List<SchedulerData>> schedulersDicionary,
            FacadeVistASite site,
            VistAConnectionInfo connectionInfo,
            DataRetrievalMethod dataRetrievalMethod
            )
        {
            Data.VistASite vistAsite = new Data.VistASite(site.Id, site.Name, site.Number, site.TimeZone, ConfigurationManager.AppSettings[site.MdwsEndpointConfigKey]);
            IVistASessionFactory vistaSessionFactory = sessionFactory.MakeSession(dataRetrievalMethod);
            Dictionary<string, VistaDataType> schedulerTypesDictionary = GetSchedulerTypesDictionary(site, dataRetrievalMethod);
            foreach (string schedulerId in schedulerTypesDictionary.Keys)
            {
                List<SchedulerData> datas = null;
                if (!schedulersDicionary.TryGetValue(schedulerId, out datas))
                {
                    datas = new List<SchedulerData>();
                    schedulersDicionary.Add(schedulerId, datas);
                }
                VistaDataType types = schedulerTypesDictionary[schedulerId];
                SchedulerData data = new SchedulerData(vistAsite, connectionInfo, vistaSessionFactory, types);
                datas.Add(data);
            }

        }

        private VistAConnectionInfo ToConnectionInfo(FacadeVistASite site)
        {
            return new VistAConnectionInfo(site.OdbcConnectionString, site.OdbcUser, site.OdbcPassword);
        }

        private Dictionary<string, VistaDataType> GetSchedulerTypesDictionary(FacadeVistASite site, DataRetrievalMethod dataRetrivalMethod)
        {

            Dictionary<string, VistaDataType> dictionaryToPopulate = new Dictionary<string, VistaDataType>();
            foreach (var type in site.DataRetrievalDetails.Keys)
            {
                var dataRetrival = site.DataRetrievalDetails[type];
                if (dataRetrival.DataRetrievalMethod == dataRetrivalMethod)
                {
                    VistaDataType keyType = (VistaDataType)((int)type);
                    string schedulerId = dataRetrival.JobCalendar.Id;
                    VistaDataType vistAType = VistaDataType.None;
                    dictionaryToPopulate.TryGetValue(schedulerId, out vistAType);
                    vistAType |= keyType;
                    dictionaryToPopulate[schedulerId] = vistAType;
                }
            }
            return dictionaryToPopulate;
        }

        public IEnumerable<CommandData> GetSchedulersCommand()
        {
            IList<FacadeVistASite> sites = FacadeManager.ConfigurationInterface.GetVistaSites(domain);
            var schedulersDictionary = new Dictionary<string, List<SchedulerData>>();
            sites.ForEach(s => OnVistASite(schedulersDictionary, s));
            return schedulersDictionary.Select(s => new CommandData(s.Key, s.Value));
        }
    }
}
