﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Exceptions;
using BMS.VistaIntegration.VistA;
using BMS.Utils;


namespace BMS.VistaIntegration.Commands
{
    public class TestConnectionCommand
    {
        private static readonly BmsLogger Logger = new BmsLogger("VistaIntegration TestConnectionCommand Message: ");
        public bool Succes { get; private set; }
        public string ErrorMessage { get; private set; }
        private readonly IVistASessionFactory sessionFactory;

        public TestConnectionCommand(IVistASessionFactory sessionFactory)
        {

            this.sessionFactory = sessionFactory;

        }


        public void Run(VistASite site, VistAConnectionInfo connection)
        {

            IVistASession session = null;
            try
            {
                session = sessionFactory.MakeVistASession(site);
                session.Open(connection);
                Succes = true;
            }
            catch (VistAConnectionException e)
            {
                Succes = false;
                ErrorMessage = e.Message;
                if (e.InnerException != null)
                {
                    Logger.LogError(e.ToString());
                }

            }
            finally
            {
                if (session != null)
                    session.Close();
            }

        }



    }
}
