﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using BMS.Schedulers.DateTimeValidators.CalendarValidators;


namespace BMS.VistaIntegration.UnitTesting.Schedulers
{

    [TestClass()]
    public class DailyRecursTest
    {

        [TestMethod()]
        public void IsValidRecursEvery1Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 1;
            DailyRecurs target = new DailyRecurs(recursEvery);
            target.Init(dateTimeStarted);
            for (int i = 0; i < 1000; i++)
            {
                DateTime value = dateTimeStarted.AddMinutes(i);
                bool actual = target.IsValid(value);
                Assert.IsTrue(actual);
            }
        }

        [TestMethod()]
        public void IsValidRecursEvery3Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 3;
            DailyRecurs target = new DailyRecurs(recursEvery);
            target.Init(dateTimeStarted);
            Assert.IsFalse(target.IsValid(dateTimeStarted));
            Assert.IsFalse(target.IsValid(dateTimeStarted.AddDays(1)));
            Assert.IsTrue(target.IsValid(dateTimeStarted.AddDays(2)));
            Assert.IsFalse(target.IsValid(dateTimeStarted.AddDays(3)));
            Assert.IsFalse(target.IsValid(dateTimeStarted.AddDays(4)));
            Assert.IsTrue(target.IsValid(dateTimeStarted.AddDays(5)));
            Assert.IsFalse(target.IsValid(dateTimeStarted.AddDays(6)));
            Assert.IsFalse(target.IsValid(dateTimeStarted.AddDays(7)));
            Assert.IsTrue(target.IsValid(dateTimeStarted.AddDays(8)));
        }

        [TestMethod()]
        public void IsValidRecursEvery10Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 10;
            DailyRecurs target = new DailyRecurs( recursEvery);
            target.Init(dateTimeStarted);
            for (int i = 0; i < 1000; i++)
            {
                bool expected = (i + 1) % 10 == 0;
                bool actual = target.IsValid(dateTimeStarted.AddDays(i));
                Assert.AreEqual(expected, actual);
            }
        }

        [TestMethod()]
        public void IsValidRecursEveryRandomTest()
        {
            Random random = new Random();
            DateTime dateTimeStarted = DateTime.UtcNow;
            int maxCount = random.Next(100, 100000);
            int recursEvery = random.Next(maxCount / 2);
            DailyRecurs target = new DailyRecurs(recursEvery);
            target.Init(dateTimeStarted);
            for (int i = 0; i < maxCount; i++)
            {
                bool expected = (i + 1) % recursEvery == 0;
                bool actual = target.IsValid(dateTimeStarted.AddDays(i));
                Assert.AreEqual(expected, actual);
            }
        }
    }
}
