﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.Maps.Fields;
using Mdws2ORM.Maps.SingleMaps;

namespace Mdws2ORM.Maps.WF
{
    public class OrderMap : EntityMap<Order>
    {
        public override string Location
        {
            get { return "OR(100,"; }
        }

        public override Order NewEntity(string ien)
        {
            return new Order() { IEN = ien };
        }


        public override string File
        {
            get { return "100"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.OrderNumber = s);            
            MapMultipleSingle(".1", (m, s) => m.OrderOrderableItemIds = s.ToList(), SingleMapFactory.MakeStringSubEntityMap("100.001"));
            MapPointerToFile<OrderStatus>("5", (m, s) => m.StatusId = s, (m, s) => m.OrderStatus = s);

            MapVariablePointer(".02",
                MakeVariablePointerItems()
                .AddFetch<Patient>(
                            (m, s) => m.PatientId = s,
                            (m, s) => m.Patient = s)
                .Add("LRT(67,", (m, s) => m.ReferralPatientId = s));

            MapVariablePointer("6",
                 MakeVariablePointerItems()
                 .AddFetch<HospitalLocation>(
                     (m, s) => m.HospitalLocationId = s, 
                     (m, s) => m.HospitalLocation = s));


        }
    }
}
