﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.EVS
{
    public class FacilityMovementTypeMap : EntityMap<FacilityMovementType>
    {
        public override string Location
        {
            get { return "DG(405.1,"; }
        }

        public override FacilityMovementType NewEntity(string ien)
        {
            return new FacilityMovementType() { IEN = ien };
        }

        public override string File
        {
            get { return "405.1"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
            MapBoolean(".04", (m, s) => m.Active = s);
        }
    }
}
