﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws.Commands;
using Mdws2ORM.Maps;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws.Commands.EntityCommands
{
    public static class EntityCommandStrategy
    {
        public static List<T> Execute<T>(ISession session, ListParam param, BaseListCommand<T> command,  out Entry LastEntry )
        where T : class
        {
            Entry currentEntry = new Entry();
            string iens = command.GetIens();
            var entities = command.EntityMap == null ?
                session.List<T>( param, iens) :
                session.List<T>(param,command.EntityMap,iens);

            var enumerable = entities
                .Select(s =>
                    {
                        currentEntry = s.Entry;
                        return s.Entity;
                    });
            Func<T,bool> predicate = command.GetPredicate();
            if (predicate != null) enumerable = enumerable.Where(predicate);
            List<T> result = enumerable.ToList();
            LastEntry = currentEntry;
            return result;
        }
    }
}
