﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Mdws.Commands.SubEntityCommands;
using Mdws2ORM;
using System;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.WF
{
    public class ListScheduledAdmissionCommand
    {
        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }
        public string PatientIen { get; set; }
        public int? MaxCount { get; set; }
        private static BmsLogger logger = new BmsLogger("Vista Integration: ListScheduledAdmissionCommand:");

        private const string PatientScreen = "I $P(^DGS(41.1,Y,0),U,1)={0} ";

        private string GetPatientScreen()
        {
            return string.IsNullOrEmpty(PatientIen) ? string.Empty : string.Format(PatientScreen, PatientIen);
        }

        private string GetScreen()
        {
            return GetPatientScreen() +
                new ScreenPeriodBuilder()
                .Format("S x=$P(^(0),U,2) I {0}")
                .Variable("x")
                .Build(StartTime, EndTime);
        }

        private void InitStartTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("C");
            IList<ScheduledAdmission> startAdm = session.List<ScheduledAdmission>(builder.Build()).Select(s => s.Entity).ToList();
            if (startAdm.Any())            
                StartTime = startAdm[0].ReservationDateTime;            
        }

        private IList<ScheduledAdmission> NoResult()
        {
            return new ScheduledAdmission[0];
        }

        public IList<ScheduledAdmission> Execute(ISession session)
        {
            if (!StartTime.HasValue)
                InitStartTime(session);
            if (!EndTime.HasValue)
                EndTime = DateTime.UtcNow.AddMonths(6);

            if (!StartTime.HasValue || !EndTime.HasValue || StartTime.Value > EndTime.Value)
                return NoResult();

            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("C");
            builder.Screen(GetScreen());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            List<ScheduledAdmission> result = new List<ScheduledAdmission>();            
            string from = Converters.ToInternalFormat(StartTime.Value.AddSeconds(-1));
            
            bool hasMore = true;
            while (hasMore)
            {
                builder.From(from);
                int size = result.Count;
                result.AddRange(session.List<ScheduledAdmission>(builder.Build()).Select(s => s.Entity));
                int partialSize = result.Count - size;
                hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;                
                if (hasMore)
                {
                    DateTime lastDateTime = result.Last().ReservationDateTime;
                    from = Converters.ToInternalFormat(lastDateTime.AddSeconds(-1));
                    while (result.Last().ReservationDateTime == lastDateTime)
                        result.RemoveAt(result.Count - 1);
                }
            }
            return result;
        }
    }
}
