﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using Mdws2ORM;
using System;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.WF
{
    public class ListPatientMovementCommand
    {
        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }

        public int? MaxCount { get; set; }
        public string PatientIen { get; set; }

        private const string PatientScreenFormat = "I $P(^DGPM(Y,0),U,3)={0} ";
        private static BmsLogger logger = new BmsLogger("Vista Integration: ListPatientMovementCommand:");

        private string GetPatientScreen()
        {
            return PatientIen != null ?
                string.Format(PatientScreenFormat, PatientIen) :
                string.Empty;
        }

        private string GetScreen()
        {
            return GetPatientScreen() +
                 new ScreenPeriodBuilder()
                .Format("I $D(^(\"USR\")) S x=$P(^(\"USR\"),U,2) I {0}")
                .Variable("x")
                .Build(StartTime, EndTime);
        }

        private void InitStartTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("B");
            IList<PatientMovement> startAdm = session.List<PatientMovement>(builder.Build()).Select(s => s.Entity).ToList();
            if (startAdm.Any())
            {
                StartTime = startAdm[0].DateTime;
            }

        }

        private void InitEndTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("B");
            builder.AppendFlags("B");
            IList<PatientMovement> endAdm = session.List<PatientMovement>(builder.Build()).Select(s => s.Entity).ToList();
            if (endAdm.Any())
            {
                EndTime = endAdm[0].DateTime.AddSeconds(1);
            }
        }

        private IList<PatientMovement> NoResult()
        {
            return new PatientMovement[0];
        }

        public IList<PatientMovement> Execute(ISession session)
        {
            if (!StartTime.HasValue)
                InitStartTime(session);
            if (!EndTime.HasValue)
                InitEndTime(session);

            if (!StartTime.HasValue || !EndTime.HasValue || StartTime.Value > EndTime.Value)
                return NoResult();


            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("B");
            builder.Screen(GetScreen());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            List<PatientMovement> result = new List<PatientMovement>();

            DateTime fromDate = StartTime.Value.AddMinutes(-10);
            string from = fromDate.Month == StartTime.Value.Month ?
                Converters.ToInternalFormat(fromDate) : "";

            foreach (string part in ParamUtilities.GetPartMonthBetweenDates(StartTime.Value, EndTime.Value))
            {
                builder.Partial(part);
                bool hasMore = true;
                while (hasMore)
                {
                    builder.From(from);
                    int size = result.Count;
                    result.AddRange(session.List<PatientMovement>(builder.Build()).Select(s => s.Entity));
                    int partialSize = result.Count - size;
                    logger.LogFormat(BmsLogger.Level.Info, "ListPatientMovementCommand: count - {0} day {1}", partialSize.ToString(), part);
                    hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                    if (hasMore)
                    {
                        DateTime lastDateTime = result.Last().DateTime;
                        from = Converters.ToInternalFormat(lastDateTime.AddSeconds(-1));
                        while (result.Last().DateTime == lastDateTime)
                            result.RemoveAt(result.Count - 1);
                    }
                }
                from = string.Empty;
            }

            List<PatientMovement> newResult = new List<PatientMovement>();
            if (result != null & result.Count > 0)
            {
                decimal transaction = 0;
                foreach (PatientMovement pm in result)
                {
                    decimal.TryParse(pm.TransactionTypeId, out transaction);
                    if ((transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MAX) ||
                        (transaction >= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MIN && transaction <= Constants.PATIENT_MOVEMENT_TRANSACTION_SPECIALTY_TRANSFER_MAX))
                        newResult.Add(pm);
                }
            }
            return newResult;

        }
    }
}
