﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Data.WF;
using System;
using BMS.VistaIntegration.Mdws.Commands.SubEntityCommands;
using Mdws2ORM;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using Mdws2ORM.Maps.SingleMaps;
using Mdws2ORM.SessionFactory;
using Mdws2ORM.Core;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class ListOrdersCommand
    {
        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }

        public IEnumerable<string> OrderableItemsIen { get; set; }
        public string PatientIen { get; set; }
        private string patientScreen;
        private string periodScreen;
        public int? MaxCount { get; set; }
        public VistASite VistaSite { get; set; }

        private const string OrderableItemsFilter = " S x=\"\" F  S x=$O(^OR(100,Y,.1,x)) Q:x=\"\"  I x>0 S v=$P(^OR(100,Y,.1,x,0),U,1) I ";
        private const string CheckOrderableItems = ",$D(^OR(100,Y,.1,0))";
        private const string QuitAppend = "Q";
        protected const string StatusScreen = "I $P(^(3),U,3)=6";
        private const string PatientScreen = ",$P(^(0),U,2)=\"{0};DPT(\"";
        private string anticipatedScreen = "  I $D(^OR(100,Y,8,a,.1)) S x=0 F  S x=$O(^OR(100,Y,8,a,.1,x)) Q:x=\"\"  S r=$ZCONVERT(^OR(100,Y,8,a,.1,x,0),\"U\") S b=b!(r[\"ANTICIPATE\"),c=c!(r[\"PLANNED\"),d=d!(r[\"DISCHARGE\") I b!c&d Q";
        public QuerySvcSoap Client { get; set; }
        private static BmsLogger logger = new BmsLogger("Vista Integration: ListOrdersCommand:");
        private const string Mdws_Query_Exception_Text_1 = "Mdws return a fault. Fault msj: A connection attempt failed";
        private const string Mdws_Query_Exception_Text_2 = "Mdws return a fault. Fault msj: [MAP]";

        private string GetOrderableItemsScreen(string orderableItemScreen)
        {
            if (OrderableItemsIen == null)
                throw new InvalidOperationException();
            StringBuilder sb = new StringBuilder(StatusScreen.Length + CheckOrderableItems.Length + patientScreen.Length + periodScreen.Length + orderableItemScreen.Length + QuitAppend.Length);
            sb.Append(StatusScreen);
            sb.Append(CheckOrderableItems);
            sb.Append(patientScreen);
            sb.Append(periodScreen);
            sb.Append(orderableItemScreen);
            sb.Append(QuitAppend);
            string result = sb.ToString();
            return result;
        }

        private string GetPatientScreen()
        {
            return string.IsNullOrEmpty(PatientIen) ?
                string.Empty :
                string.Format(PatientScreen, PatientIen);
        }

        private int AddToResult(IEnumerable<OrderAction> values, HashSet<string> distinctOrders, List<OrderAction> result)
        {
            int size = 0;
            foreach (OrderAction o in values)
            {
                if (distinctOrders.Add(o.OrderId))
                {
                    size++;
                    result.Add(o);
                }
                else if (!string.IsNullOrEmpty(o.OrderText) && ((o.OrderText.ToUpper().Contains("ANTICIPATE") || o.OrderText.ToUpper().Contains("PLANNED")) && o.OrderText.ToUpper().Contains("DISCHARGE")))
                {
                    result.RemoveAll(a => a.OrderId.Equals(o.OrderId, StringComparison.InvariantCultureIgnoreCase));
                    result.Add(o);
                }
            }
            return size;
        }


        private string GetScreenFilterByAnticipatedDischarge()
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(StatusScreen);
            sb.Append(patientScreen);
            sb.Append(new ScreenPeriodBuilder()
                    .Format(" S (a,b,c,d)=0 I $D(^OR(100,Y,8)) F  S a=$O(^OR(100,Y,8,a)) Q:(a=\"\")!(a]\"A\")  S v=$P(^OR(100,Y,8,a,0),U,1) I {0}")
                    .Variable("v").Build(StartTime, EndTime));            
            sb.Append(anticipatedScreen);
            string result = sb.ToString();
            return result;
        }


        private IEnumerable<string> GetScreenFilterByOrderableItems(int maxCount)
        {
            StringBuilder sb = new StringBuilder(OrderableItemsFilter);
            foreach (string s in OrderableItemsIen)
            {
                string add = string.Format("(v={0})!", s);
                if (s.Length + sb.Length >= maxCount)
                {
                    sb[sb.Length - 1] = ' ';
                    yield return sb.ToString();
                    sb = new StringBuilder(OrderableItemsFilter);
                }
                sb.Append(add);
            }
            sb[sb.Length - 1] = ' ';
            yield return sb.ToString();
        }

        private void InitStartTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("AF");
            IEntryQuery query = BmsSessionFactory.SessionFactory.MakeEntryQuery(Client, VistaSite);
            IFieldsParamFactory fieldsFactory = BmsSessionFactory.SessionFactory.MakeFieldsParamFactory();

            IList<Entry> list = query.List(new QueryParam("100", fieldsFactory.MakeListFieldsParam(new string[] { "IX" }), new string[] { "0" }), builder.Build(), VistaSite);

            if (list.Any())
            {
                StartTime = Converters.ToDateTime(list[0].Fields[0].Value);
            }

        }

        private void InitEndTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("AF");
            builder.AppendFlags("B");

            IEntryQuery query = BmsSessionFactory.SessionFactory.MakeEntryQuery(Client, VistaSite);
            IFieldsParamFactory fieldsFactory = BmsSessionFactory.SessionFactory.MakeFieldsParamFactory();

            IList<Entry> list = query.List(new QueryParam("100", fieldsFactory.MakeListFieldsParam(new string[] { "IX" }), new string[] { "0" }), builder.Build(), VistaSite);
            if (list.Any())
            {
                EndTime = Converters.ToDateTime(list[0].Fields[0].Value);
                if (EndTime.HasValue && EndTime.Value.Second == 0)
                    EndTime = EndTime.Value.AddSeconds(59);
            }
        }

        private IList<OrderAction> NoResult()
        {
            return new OrderAction[0];
        }

        private void AddOrdersFilterByOrderableItems(ISession session, HashSet<string> distinctOrders, List<OrderAction> result)
        {
            if (OrderableItemsIen == null)
                throw new InvalidOperationException();

            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("AF");
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            ListParam subParam = new ListParamBuilder()
                 .Number("1")
                 .AppendFlags("B")
                 .Build();

            int maxCount = ParamUtilities.MAX_SIZE - StatusScreen.Length - patientScreen.Length - periodScreen.Length - QuitAppend.Length - CheckOrderableItems.Length;


            foreach (string partScreen in GetScreenFilterByOrderableItems(maxCount))
            {
                builder.Screen(GetOrderableItemsScreen(partScreen));
                DateTime fromDate = StartTime.Value.AddSeconds(-1);
                string from = fromDate.Day == StartTime.Value.Day ?
                    Converters.ToInternalFormat(fromDate) : "";
                foreach (string part in GetPartDaysBetweenDates(StartTime.Value, EndTime.Value))
                {
                    builder.Partial(part);
                    bool hasMore = true;
                    while (hasMore)
                    {
                        builder.From(from);
                        int partialSize = 0;
                        IEnumerable<ListItem<OrderAction>> partial = null;
                        try
                        {                            
                            partial = session.ListAllSubEntities<OrderAction, Order>(builder.Build(), subParam);
                            partialSize = AddToResult(partial.Select(s => s.Entity), distinctOrders, result);                         
                        }
                        catch (Exception ex)
                        {
                            Tracer.TraceMessage(VistaSite.Name + " ListOrdersCommand by orderable items exception");
                            Tracer.TraceException(ex);
                            if (ex.Message.Contains(Mdws_Query_Exception_Text_1) || (ex.InnerException != null && ex.InnerException.Message.Contains(Mdws_Query_Exception_Text_1))
                                || ex.Message.Contains(Mdws_Query_Exception_Text_2) || (ex.InnerException != null && ex.InnerException.Message.Contains(Mdws_Query_Exception_Text_2)))
                            {
                                int startHour = 0, endHour = 0;
                                GetStartEndHours(StartTime.Value, EndTime.Value, out startHour, out endHour);
                                Tracer.TraceMessage(VistaSite.Name + " - ListOrdersCommand by orderable items Partial: " + part + " StartHour: " + startHour + " EndHour: " + endHour);
                                string tempPart = null;
                                for (int i = startHour; i <= endHour; i++)
                                {
                                    if (i < 10)
                                        tempPart = part + ".0" + i.ToString();
                                    else
                                        tempPart = part + "." + i.ToString();
                                    builder.Partial(tempPart);
                                    try
                                    {
                                        partial = session.ListAllSubEntities<OrderAction, Order>(builder.Build(), subParam);
                                        AddToResult(partial.Select(s => s.Entity), distinctOrders, result);
                                        Tracer.TraceMessage("ListOrdersCommand with part: " + tempPart + " Result count: " + ((partial != null) ? partial.Count().ToString() : "0"));
                                    }
                                    catch (Exception ex2)
                                    {
                                        Tracer.TraceMessage(VistaSite.Name + " - ListOrdersCommand by orderable items Exception for partial with hour: " + tempPart);
                                        Tracer.TraceException(ex2);
                                        throw ex2;
                                    }
                                }
                                break;
                            }
                            else
                                throw ex;
                        }                        
                        logger.LogFormat(BmsLogger.Level.Info, "AddOrdersFilterByOrderableItems: count - {0} day {1}", partialSize, part);
                        hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                        if (hasMore)
                        {
                            DateTime lastDateTime = result.Last().DateTimeOrdered;
                            from = Converters.ToInternalFormat(lastDateTime.AddSeconds(-1));
                        }
                    }
                    from = string.Empty;
                }
            }
        }

        private void AddAnticipatedDischargeOrders(ISession session, HashSet<string> distinctOrders, List<OrderAction> result)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("AF");
            builder.Screen(GetScreenFilterByAnticipatedDischarge());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            ListParam subParam = new ListParamBuilder()
                   .Number("1")
                   .AppendFlags("B")
                   .Screen("S a=Y(1),b=0,c=0,d=0,x=\"\" F  S x=$O(^OR(100,a,8,Y,.1,x)) Q:x=\"\"  I x>0 S r=$ZCONVERT(^OR(100,a,8,Y,.1,x,0),\"U\") S b=b!(r[\"ANTICIPATE\"),c=c!(r[\"PLANNED\"),d=d!(r[\"DISCHARGE\")  I b!c&d Q")
                   .Build();

            DateTime fromDate = StartTime.Value.AddSeconds(-1);
            string from = fromDate.Day == StartTime.Value.Day ?
                Converters.ToInternalFormat(fromDate) : "";

            foreach (string part in GetPartDaysBetweenDates(StartTime.Value, EndTime.Value))
            {
                builder.Partial(part);
                bool hasMore = true;
                while (hasMore)
                {
                    builder.From(from);
                    int partialSize = 0;
                    IEnumerable<ListItem<OrderAction>> partial = null;
                    try
                    {
                        partial = session.ListAllSubEntities<OrderAction, Order>(builder.Build(), subParam);
                        partialSize = AddToResult(partial.Select(s => s.Entity), distinctOrders, result);
                    }
                    catch (Exception ex)
                    {
                        Tracer.TraceMessage(VistaSite.Name + " ListOrdersCommand Anticipated exception");
                        Tracer.TraceException(ex);
                        if (ex.Message.Contains(Mdws_Query_Exception_Text_1) || (ex.InnerException != null && ex.InnerException.Message.Contains(Mdws_Query_Exception_Text_1))
                            || ex.Message.Contains(Mdws_Query_Exception_Text_2) || (ex.InnerException != null && ex.InnerException.Message.Contains(Mdws_Query_Exception_Text_2)))
                        {
                            int startHour = 0, endHour = 0;
                            GetStartEndHours(StartTime.Value, EndTime.Value, out startHour, out endHour);
                            Tracer.TraceMessage(VistaSite.Name + " - ListOrdersCommand Anticipated Partial: " + part + " StartHour: " + startHour + " EndHour: " + endHour);
                            string tempPart = null;
                            for (int i = startHour; i <= endHour; i++)
                            {
                                if (i < 10)
                                    tempPart = part + ".0" + i.ToString();
                                else
                                    tempPart = part + "." + i.ToString();
                                builder.Partial(tempPart);
                                try
                                {
                                    partial = session.ListAllSubEntities<OrderAction, Order>(builder.Build(), subParam);
                                    AddToResult(partial.Select(s => s.Entity), distinctOrders, result);
                                }
                                catch (Exception ex2)
                                {
                                    Tracer.TraceMessage(VistaSite.Name + " - ListOrdersCommand Anticipated Exception for partial with hour: " + tempPart);
                                    Tracer.TraceException(ex2);
                                    throw ex2;
                                }
                            }
                            break;
                        }
                        else
                            throw ex;
                    }                    
                    logger.LogFormat(BmsLogger.Level.Info, "AddAnticipatedDischargeOrders: count - {0} day {1}", partialSize, part);
                    hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                    if (hasMore)
                    {
                        DateTime lastDateTime = result.Last().DateTimeOrdered;
                        from = Converters.ToInternalFormat(lastDateTime.AddSeconds(-1));
                    }
                }
                from = string.Empty;
            }
        }

        public static IEnumerable<string> GetPartDaysBetweenDates(DateTime startTime, DateTime endTime)
        {
            DateTime time = startTime.Date;
            while (time <= endTime)
            {
                yield return GetDayPart(time);
                time = time.AddDays(1);
            }
        }

        public static string GetDayPart(DateTime time)
        {
            return Converters.ToInternalFormat(time).Substring(0, 7);
        }

        public IList<OrderAction> Execute(ISession session)
        {
            if (!StartTime.HasValue)
                InitStartTime(session);
            if (!EndTime.HasValue)
                InitEndTime(session);

            if (!StartTime.HasValue || !EndTime.HasValue || StartTime.Value > EndTime.Value)
                return NoResult();


            periodScreen = new ScreenPeriodBuilder()
                    .Format(" S a=$P(^OR(100,Y,3),U,7),v=$P(^OR(100,Y,3),U,1) I a>0,{0} S v=$P(^OR(100,Y,8,a,0),U,1) I {0}")
                    .Variable("v").Build(StartTime, EndTime);
            patientScreen = GetPatientScreen();

            List<OrderAction> result = new List<OrderAction>();
            HashSet<string> distinctOrders = new HashSet<string>();

            AddOrdersFilterByOrderableItems(session, distinctOrders, result);
            AddAnticipatedDischargeOrders(session, distinctOrders, result);            

            return result;

        }

        private static void GetStartEndHours(DateTime startDate, DateTime endDate, out int startHour, out int endHour)
        {
            if (startDate.Year == endDate.Year && startDate.Month == endDate.Month && startDate.Day == endDate.Day)
            {
                startHour = startDate.Hour;
                endHour = endDate.Hour;
            }
            else
            {
                startHour = 0;
                endHour = 23;
            }
        }
    }
}
