﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;

namespace BMS.VistaIntegration.Mdws.Commands
{
    public abstract class BaseListPeriodCommand<T> : BaseListCommand<T> where T : class
    {
        public DateTime? StartDate { get; set; }
        public DateTime? EndDate { get; set; }

        private ScreenPeriodBuilder screenPeriodBuilder = new ScreenPeriodBuilder();

        protected abstract void InitScreenPeriodBuilder(ScreenPeriodBuilder screenPeriodBuilder);

        public BaseListPeriodCommand()
        {
            InitScreenPeriodBuilder(screenPeriodBuilder);
        }

        protected string GetPeriodScreen()
        {
            return screenPeriodBuilder.Build(StartDate, EndDate);
        }

        protected override string GetScreen()
        {
            return GetPeriodScreen();
        }
    }
}
