﻿using System;
using System.Collections.Generic;
using System.Linq;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.IO;
using System.Reflection;
using BMS.Utils;
using System.Diagnostics;
using BMS.ServicesWrapper.EIS;
using BMS.Facade;
using System.Xml.Linq;
using System.Collections;
using BMS.Utils;

namespace BMS.Vista.TestEis
{
    class Program
    {


        static void Main(string[] args)
        {
            Console.Out.WriteLine("Running...");
            FacadeManager.EntityInterface.ClearCache();
            EisTree tree = new EisTree();
            InitTree(tree);
            InitTypes(tree);
            tree.Run();
        }

        private static void InitTree(EisTree tree)
        {
            tree.AddDefaultFunc<Region>(() => EIS.GetRegions());
            tree.AddFunc<Region, Visn>(r => EIS.GetVisns(r.Id));
            tree.AddFunc<Visn, Facility>(v => EIS.GetFacilities(v.Id));
            tree.AddFunc<Facility, Division>(f => Enumerable.Concat(  EIS.GetDivisions(f.Id) , GetVirtualDivision(f) ));
            tree.AddFunc<Division, Ward>(d => EIS.GetWards(null, d.Id));
            tree.AddFunc<Ward, Bed>(b => EIS.GetBedsInWard(b.Id));
        }

        private static void InitTypes(EisTree tree)
        {
            tree.AddStringType<II>(KnownTypes.ToString);
            tree.AddStringType<CD>(KnownTypes.ToString);
            tree.AddStringType<Region>(KnownTypes.ToString);
            tree.AddStringType<Visn>(KnownTypes.ToString);
            tree.AddStringType<Facility>(KnownTypes.ToString);
            tree.AddStringType<Division>(KnownTypes.ToString);
            tree.AddStringType<Ward>(KnownTypes.ToString);
            tree.AddStringType<Bed>(KnownTypes.ToString);
        }


        private static IEnumerable<Division> GetVirtualDivision(Facility facility)
        { 
            var virtualDivision = EIS.FindDivision(facility.Id, EISConstants.NEW_DIVISION_NAME);
            if (virtualDivision != null) yield return virtualDivision;
        }

        private static IEISWrapper EIS
        {
            get
            {
                return EISFactory.Instance;
            }
        }


    }
}
