﻿using System;
using System.Collections.Generic;
using InfoWorld.HL7.ITS;

namespace BMS.Utils
{
    /// <summary>
    /// IEqualityComparer used for the cache dictionary.
    /// </summary>
    public class IIComparer : IEqualityComparer<II>
    {
        /// <summary>
        /// Static instance of IIComparer.
        /// </summary>
        public static IIComparer Instance = new IIComparer();

        /// <summary>
        /// Checks to see whether two II are the same by comparing references
        /// or root and extension propeties.
        /// </summary>
        /// <param name="x">first II</param>
        /// <param name="y">second II</param>
        /// <returns></returns>
        public bool Equals(II x, II y)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (Object.ReferenceEquals(x, y))
                    return true;

                if (Object.ReferenceEquals(x, null) || Object.ReferenceEquals(y, null))
                    return false;

                return string.Equals(x.root, y.root, StringComparison.InvariantCultureIgnoreCase)
                    && string.Equals(x.extension, y.extension, StringComparison.InvariantCultureIgnoreCase);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        /// <summary>
        /// Computes the hashcode for a II used within the dictionary based on the 
        /// same properties as the Equals method using XOR operator.
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public int GetHashCode(II obj)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (Object.ReferenceEquals(obj, null))
                    return 0;

                int hashRoot = obj.root == null ? 0 : obj.root.GetHashCode();
                int hashExtension = obj.extension == null ? 0 : obj.extension.GetHashCode();

                return hashRoot ^ hashExtension;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
