﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.Proxy.WF;
using BMS.Utils;

namespace BMS.ServicesWrapper.WF
{
    public class WFFactory
    {
        /// <summary>
        /// Access to the BMS Transfer Workflow proxy.
        /// </summary>
        public static BMSWorkflowsWFITransferFlowClient TransferWorkflowClient
        {
            get { return ProxyManager.GetProxy<BMSWorkflowsWFITransferFlowClient>("BMSWF.ITransferFlow"); }
        }

        /// <summary>
        /// Access to the BMS Transfer Workflow proxy using Windows authentication.
        /// </summary>
        public static BMSWorkflowsWFITransferFlowClient TransferWorkflowClientWindows
        {
            get { return ProxyManager.GetProxy<BMSWorkflowsWFITransferFlowClient>("BMSWF.ITransferFlow.Windows"); }
        }               

        /// <summary>
        /// Access to the Bed Unavailable Workflow proxy.
        /// </summary>
        public static BMSWorkflowsWFIBedUnavailableFlowClient BedUnavailableWorkflowClient
        {
            get { return ProxyManager.GetProxy<BMSWorkflowsWFIBedUnavailableFlowClient>("BMSWF.IBedUnavailableFlow"); }
        }
        /// <summary>
        /// Access to the Bed Unavailable Workflow proxy using Windows authentication.
        /// </summary>
        public static BMSWorkflowsWFIBedUnavailableFlowClient BedUnavailableWorkflowClientWindows
        {
            get { return ProxyManager.GetProxy<BMSWorkflowsWFIBedUnavailableFlowClient>("BMSWF.IBedUnavailableFlow.Windows"); }
        }

        /// <summary>
        /// Access to the Waiting List Workflow proxy.
        /// </summary>
        public static BMSWorkflowsWFIWaitingListFlowClient WaitingListFlowClient
        {
            get
            {
                return ProxyManager.GetProxy<BMSWorkflowsWFIWaitingListFlowClient>("BMSWF.IWaitingListFlow");
            }
        }
        /// <summary>
        /// Access to the Waiting List Workflow proxy using Windows authentication.
        /// </summary>
        public static BMSWorkflowsWFIWaitingListFlowClient WaitingListFlowClientWindows
        {
            get
            {
                return ProxyManager.GetProxy<BMSWorkflowsWFIWaitingListFlowClient>("BMSWF.IWaitingListFlow.Windows");
            }
        }

        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static BMSWorkflowsWFIWaitingListFlowClient WaitingListFlowClientFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return WaitingListFlowClient;
                else
                    return WaitingListFlowClientWindows;
            }
        }
    }
}
