﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using FC = BMS.Facade.Data;
using BMS.DataContracts;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.FaultContracts;
using BMS.Facade.Fault;

namespace BMS.ServicesWrapper.Proxy.WF
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Name = "BMS.Workflows.WF.ITransferFlow", ConfigurationName = "BMS.Workflows.WF.ITransferFlow")]
    public interface BMSWorkflowsWFITransferFlow
    {

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/CreateTransferRequest", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/CreateTransferRequestRespo" +
            "nse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/CreateTransferRequestGener" +
            "icWFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "pTransferRequestId")]
        II CreateTransferRequest(FC.Transfer pTransferRequest);

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/CreateTransferEvent", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/CreateTransferEventRespons" +
            "e")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/CreateTransferEventGeneric" +
            "WFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "pTransferEventId")]
        II CreateTransferEvent(FC.Transfer pTransferEvent);

        [System.ServiceModel.OperationContractAttribute(ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Action = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/UpdateTransferRequest", ReplyAction = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/UpdateTransferRequestRespo" +
            "nse")]
        [System.ServiceModel.FaultContractAttribute(typeof(GenericWFServiceFault), Action = "http://tempuri.org/BMS.Workflows.WF.ITransferFlow/UpdateTransferRequestGener" +
            "icWFServiceFaultFault", ProtectionLevel = System.Net.Security.ProtectionLevel.EncryptAndSign, Name = "GenericWFServiceFault", Namespace = "http://schemas.datacontract.org/2004/07/BMS.Facade.Fault")]
        void UpdateTransferRequest(FC.Transfer pTransferRequest);
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface BMSWorkflowsWFITransferFlowChannel : BMSWorkflowsWFITransferFlow, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BMSWorkflowsWFITransferFlowClient : System.ServiceModel.ClientBase<BMSWorkflowsWFITransferFlow>, BMSWorkflowsWFITransferFlow, IDisposable
    {
        #region ProxyTool Generated Code

        private BMSWorkflowsWFITransferFlowClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BMSWorkflowsWFITransferFlowClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BMSWorkflowsWFITransferFlowClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BMSWorkflowsWFITransferFlowClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BMSWorkflowsWFITransferFlowClient(_endpointConfigurationName);
                else
                    _instance = new BMSWorkflowsWFITransferFlowClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFITransferFlow>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFITransferFlow>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFITransferFlow>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BMSWorkflowsWFITransferFlow>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public BMSWorkflowsWFITransferFlowClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFITransferFlowClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFITransferFlowClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFITransferFlowClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BMSWorkflowsWFITransferFlowClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateTransferRequest(FC.Transfer pTransferRequest)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateTransferRequest(pTransferRequest);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateTransferRequest(pTransferRequest);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFITransferFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public II CreateTransferEvent(FC.Transfer pTransferEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.CreateTransferEvent(pTransferEvent);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.CreateTransferEvent(pTransferEvent);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFITransferFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public void UpdateTransferRequest(FC.Transfer pTransferRequest)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    _instance.Channel.UpdateTransferRequest(pTransferRequest);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        _instance.Channel.UpdateTransferRequest(pTransferRequest);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BMSWorkflowsWFITransferFlowClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
