using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.EVS.CTSVAPI;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EVS.VAPI
{
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [System.ServiceModel.ServiceContractAttribute(Namespace = "urn://hl7.org/CTSVAPI", ConfigurationName = "InfoWorld.EVS.CTSVAPI.BrowserOperations")]
    public interface BrowserOperations
    {
        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedMatchAlgorithms", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedMatchAlgorithmsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedMatchAlgorithmsUnexpectedErro" +
            "rFault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedMatchAlgorithmsReturn")]
        string[] getSupportedMatchAlgorithms();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedCodeSystems", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedCodeSystemsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedCodeSystemsTimeoutErrorFault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getSupportedCodeSystemsUnexpectedErrorFau" +
            "lt", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getSupportedCodeSystemsReturn")]
        CodeSystemIdAndVersions[] getSupportedCodeSystems(int in0, int in1);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignation", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationTimeoutErr" +
            "orFault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMatchAlgorithm), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationUnknownMat" +
            "chAlgorithmFault", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(BadlyFormedMatchText), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationBadlyForme" +
            "dMatchTextFault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguageCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationUnknownLan" +
            "guageCodeFault", Name = "UnknownLanguageCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationUnexpected" +
            "ErrorFault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByDesignationUnknownCod" +
            "eSystemFault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByDesignationReturn")]
        ConceptId[] lookupConceptCodesByDesignation(string in0, string in1, string in2, string in3, bool in4, int in5, int in6);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByProperty", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(BadlyFormedMatchText), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyBadlyFormedMa" +
            "tchTextFault", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownPropertyCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyUnknownProper" +
            "tyCodeFault", Name = "UnknownPropertyCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyTimeoutErrorF" +
            "ault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguageCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyUnknownLangua" +
            "geCodeFault", Name = "UnknownLanguageCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMimeTypeCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyUnknownMimeTy" +
            "peCodeFault", Name = "UnknownMimeTypeCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyUnexpectedErr" +
            "orFault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyUnknownCodeSy" +
            "stemFault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMatchAlgorithm), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupConceptCodesByPropertyUnknownMatchA" +
            "lgorithmFault", Name = "UnknownMatchAlgorithm")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupConceptCodesByPropertyReturn")]
        ConceptId[] lookupConceptCodesByProperty(string in0, string in1, string in2, string in3, bool in4, string[] in5, string[] in6, int in7, int in8);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCompleteCodedConcept", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCompleteCodedConceptResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCompleteCodedConceptUnknownConceptC" +
            "odeFault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCompleteCodedConceptUnexpectedError" +
            "Fault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCompleteCodedConceptUnknownCodeSyst" +
            "emFault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupCompleteCodedConceptReturn")]
        CompleteCodedConceptDescription lookupCompleteCodedConcept(ConceptId in0);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignations", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsUnexpectedErrorFault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(BadlyFormedMatchText), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsBadlyFormedMatchTextFau" +
            "lt", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguageCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsUnknownLanguageCodeFaul" +
            "t", Name = "UnknownLanguageCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMatchAlgorithm), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsUnknownMatchAlgorithmFa" +
            "ult", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsUnknownConceptCodeFault" +
            "", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupDesignationsUnknownCodeSystemFault", Name = "UnknownCodeSystem")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupDesignationsReturn")]
        ConceptDesignation[] lookupDesignations(ConceptId in0, string in1, string in2, string in3);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupProperties", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMimeTypeCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnknownMimeTypeCodeFault", Name = "UnknownMimeTypeCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownMatchAlgorithm), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnknownMatchAlgorithmFaul" +
            "t", Name = "UnknownMatchAlgorithm")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnknownConceptCodeFault", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnknownCodeSystemFault", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnexpectedErrorFault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(BadlyFormedMatchText), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesBadlyFormedMatchTextFault" +
            "", Name = "BadlyFormedMatchText")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownPropertyCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnknownPropertyCodeFault", Name = "UnknownPropertyCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguageCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupPropertiesUnknownLanguageCodeFault", Name = "UnknownLanguageCode")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupPropertiesReturn")]
        ConceptProperty[] lookupProperties(ConceptId in0, string[] in1, string in2, string in3, string in4, string[] in5);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansion", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionUnexpectedErrorFault", Name = "UnexpectedError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownConceptCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionUnknownConceptCodeFaul" +
            "t", Name = "UnknownConceptCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionTimeoutErrorFault", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownCodeSystem), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionUnknownCodeSystemFault" +
            "", Name = "UnknownCodeSystem")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownLanguageCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionUnknownLanguageCodeFau" +
            "lt", Name = "UnknownLanguageCode")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnknownRelationshipCode), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/lookupCodeExpansionUnknownRelationshipCod" +
            "eFault", Name = "UnknownRelationshipCode")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "lookupCodeExpansionReturn")]
        RelatedCode[] lookupCodeExpansion(ConceptId in0, string in1, bool in2, bool in3, string in4, int in5, int in6);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/expandCodeExpansionContext", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/expandCodeExpansionContextResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(InvalidExpansionContext), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/expandCodeExpansionContextInvalidExpansio" +
            "nContextFault", Name = "InvalidExpansionContext")]
        [System.ServiceModel.FaultContractAttribute(typeof(TimeoutError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/expandCodeExpansionContextTimeoutErrorFau" +
            "lt", Name = "TimeoutError")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/expandCodeExpansionContextUnexpectedError" +
            "Fault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "expandCodeExpansionContextReturn")]
        RelatedCode[] expandCodeExpansionContext(byte[] in0);

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceName", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceNameResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceNameUnexpectedErrorFault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceNameReturn")]
        string getServiceName();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceVersion", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceVersionUnexpectedErrorFault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceVersionReturn")]
        string getServiceVersion();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceDescription", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceDescriptionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getServiceDescriptionUnexpectedErrorFault" +
            "", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getServiceDescriptionReturn")]
        string getServiceDescription();

        [System.ServiceModel.OperationContractAttribute(Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getCTSVersion", ReplyAction = "urn://hl7.org/CTSVAPI/BrowserOperations/getCTSVersionResponse")]
        [System.ServiceModel.FaultContractAttribute(typeof(UnexpectedError), Action = "urn://hl7.org/CTSVAPI/BrowserOperations/getCTSVersionUnexpectedErrorFault", Name = "UnexpectedError")]
        [return: System.ServiceModel.MessageParameterAttribute(Name = "getCTSVersionReturn")]
        CTSVersionId getCTSVersion();
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface BrowserOperationsChannel : BrowserOperations, System.ServiceModel.IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class BrowserOperationsClient : System.ServiceModel.ClientBase<BrowserOperations>, BrowserOperations, System.IDisposable
    {
        #region ProxyTool Generated Code

        private BrowserOperationsClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new BrowserOperationsClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new BrowserOperationsClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new BrowserOperationsClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new BrowserOperationsClient(_endpointConfigurationName);
                else
                    _instance = new BrowserOperationsClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<BrowserOperations>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public BrowserOperationsClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public BrowserOperationsClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string[] getSupportedMatchAlgorithms()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedMatchAlgorithms();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedMatchAlgorithms();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CodeSystemIdAndVersions[] getSupportedCodeSystems(int in0, int in1)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getSupportedCodeSystems(in0, in1);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getSupportedCodeSystems(in0, in1);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ConceptId[] lookupConceptCodesByDesignation(string in0, string in1, string in2, string in3, bool in4, int in5, int in6)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByDesignation(in0, in1, in2, in3, in4, in5, in6);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByDesignation(in0, in1, in2, in3, in4, in5, in6);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ConceptId[] lookupConceptCodesByProperty(string in0, string in1, string in2, string in3, bool in4, string[] in5, string[] in6, int in7, int in8)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupConceptCodesByProperty(in0, in1, in2, in3, in4, in5, in6, in7, in8);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupConceptCodesByProperty(in0, in1, in2, in3, in4, in5, in6, in7, in8);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CompleteCodedConceptDescription lookupCompleteCodedConcept(ConceptId in0)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupCompleteCodedConcept(in0);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupCompleteCodedConcept(in0);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ConceptDesignation[] lookupDesignations(ConceptId in0, string in1, string in2, string in3)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupDesignations(in0, in1, in2, in3);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupDesignations(in0, in1, in2, in3);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ConceptProperty[] lookupProperties(ConceptId in0, string[] in1, string in2, string in3, string in4, string[] in5)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupProperties(in0, in1, in2, in3, in4, in5);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupProperties(in0, in1, in2, in3, in4, in5);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RelatedCode[] lookupCodeExpansion(ConceptId in0, string in1, bool in2, bool in3, string in4, int in5, int in6)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.lookupCodeExpansion(in0, in1, in2, in3, in4, in5, in6);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.lookupCodeExpansion(in0, in1, in2, in3, in4, in5, in6);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public RelatedCode[] expandCodeExpansionContext(byte[] in0)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.expandCodeExpansionContext(in0);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.expandCodeExpansionContext(in0);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string getServiceName()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceName();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceName();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string getServiceVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public string getServiceDescription()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getServiceDescription();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getServiceDescription();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public CTSVersionId getCTSVersion()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.getCTSVersion();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.getCTSVersion();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<BrowserOperationsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }

}
