using System.Runtime.Serialization;
using System.Collections.Generic;
using System;

using InfoWorld.HL7.ITS;
using InfoWorld.HL7.ITS.Extension.EIS;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy.EIS
{

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "3.0.0.0")]
    public interface IQueryFunctionsChannel : InfoWorld.EIS.IQueryFunctions, System.ServiceModel.IClientChannel
    {
    }

    [System.CodeDom.Compiler.GeneratedCodeAttribute("System.ServiceModel", "3.0.0.0")]
    public partial class QueryFunctionsClient : System.ServiceModel.ClientBase<InfoWorld.EIS.IQueryFunctions>, InfoWorld.EIS.IQueryFunctions, System.IDisposable
    {
        #region ProxyTool Generated Code

        private QueryFunctionsClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;


        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new QueryFunctionsClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new QueryFunctionsClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new QueryFunctionsClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new QueryFunctionsClient(_endpointConfigurationName);
                else
                    _instance = new QueryFunctionsClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<InfoWorld.EIS.IQueryFunctions>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<InfoWorld.EIS.IQueryFunctions>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<InfoWorld.EIS.IQueryFunctions>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<InfoWorld.EIS.IQueryFunctions>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion


        public QueryFunctionsClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public QueryFunctionsClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public QueryFunctionsClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public QueryFunctionsClient(string endpointConfigurationName, System.ServiceModel.EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public QueryFunctionsClient(System.ServiceModel.Channels.Binding binding, System.ServiceModel.EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region IQueryFunctions Members

        public List<Entity> FindEntitiesByTrait(TraitList TraitListInput, List<string> TraitListOutputIdentifiers, List<string> DomainIdentifiers, List<string> EntityTypeIdentifiers)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FindEntitiesByTrait(TraitListInput, TraitListOutputIdentifiers, DomainIdentifiers, EntityTypeIdentifiers);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FindEntitiesByTrait(TraitListInput, TraitListOutputIdentifiers, DomainIdentifiers, EntityTypeIdentifiers);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<Entity> FindEntitiesByTraitWithPaging(TraitList TraitListInput, List<string> TraitListOutputIdentifiers, List<string> DomainIdentifiers, List<string> EntityTypeIdentifiers, string lastIndexes, int pageCount, out string lastIndexesResult)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FindEntitiesByTraitWithPaging(TraitListInput, TraitListOutputIdentifiers, DomainIdentifiers, EntityTypeIdentifiers, lastIndexes, pageCount, out lastIndexesResult);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FindEntitiesByTraitWithPaging(TraitListInput, TraitListOutputIdentifiers, DomainIdentifiers, EntityTypeIdentifiers, lastIndexes, pageCount, out lastIndexesResult);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public Entity GetInformationForEntity(string domainIdentifier, string entityTypeIdentifier, string entityIdentifier)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetInformationForEntity(domainIdentifier, entityTypeIdentifier, entityIdentifier);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetInformationForEntity(domainIdentifier, entityTypeIdentifier, entityIdentifier);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<Entity> ListEntitiesByEntityTypeAndDomain(string domainIdentifier, string entityTypeIdentifier, List<string> traitIdentifiers, CE status)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.ListEntitiesByEntityTypeAndDomain(domainIdentifier, entityTypeIdentifier, traitIdentifiers, status);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.ListEntitiesByEntityTypeAndDomain(domainIdentifier, entityTypeIdentifier, traitIdentifiers, status);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<Entity> ListLinkedEntities(string domainIdentifier, string entityTypeIdentifier, string entityIdentifier, List<string> domainIdentifiers)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.ListLinkedEntities(domainIdentifier, entityTypeIdentifier, entityIdentifier, domainIdentifiers);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.ListLinkedEntities(domainIdentifier, entityTypeIdentifier, entityIdentifier, domainIdentifiers);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<SupportDomain> ListSupportedDomains()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.ListSupportedDomains();
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.ListSupportedDomains();
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<SupportedEntityClassifier> ListSupportedEntityTypesClassifiers(List<string> listOfEntitiesTypesClassifier)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.ListSupportedEntityTypesClassifiers(listOfEntitiesTypesClassifier);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.ListSupportedEntityTypesClassifiers(listOfEntitiesTypesClassifier);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<SupportedTrait> ListTraitDefinitions(List<string> listOfTraitsIdentifiers)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.ListTraitDefinitions(listOfTraitsIdentifiers);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.ListTraitDefinitions(listOfTraitsIdentifiers);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public List<Entity> FindEntitiesById(List<string> entityIdentifiers, string entityTypeIdentifier, string domainIdentifier, List<string> traitListOutputIdentifiers)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.FindEntitiesById(entityIdentifiers, entityTypeIdentifier, domainIdentifier, traitListOutputIdentifiers);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.FindEntitiesById(entityIdentifiers, entityTypeIdentifier, domainIdentifier, traitListOutputIdentifiers);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<QueryFunctionsClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion


    }
}