﻿using System;
using System.Xml;
using System.Collections.Generic;
using System.Xml.Serialization;
using System.ServiceModel;
using System.ServiceModel.Channels;
using System.CodeDom.Compiler;
using System.ComponentModel;
using System.Diagnostics;
using BMS.Utils;

namespace BMS.ServicesWrapper.Proxy
{
    [GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [ServiceContractAttribute(Namespace = "http://NumiExchange/", ConfigurationName = "BMS.ServicesWrapper.Proxy.InpatientSoap")]
    public interface InpatientSoap
    {
        [OperationContractAttribute(Action = "http://NumiExchange/GetLevelOfCareBySite", ReplyAction = "*")]
        [XmlSerializerFormatAttribute(SupportFaults = true)]
        GetLevelOfCareBySiteResponse GetLevelOfCareBySite(GetLevelOfCareBySiteRequest request);
    }

    [GeneratedCodeAttribute("System.Xml", "4.0.30319.233")]
    [SerializableAttribute()]
    [DebuggerStepThroughAttribute()]
    [DesignerCategoryAttribute("code")]
    [XmlTypeAttribute(Namespace = "http://NumiExchange/")]
    public partial class ExchangeAuthentication : object, INotifyPropertyChanged
    {
        private Guid authenticationIDField;
        private string contactEmailField;
        private string contactPhoneField;
        private Nullable<DateTime> dateCreatedField;
        private Nullable<DateTime> dateInactiveField;
        private Nullable<DateTime> dateModifiedField;
        private bool inactiveField;
        private string teamContactField;
        private string teamNameField;
        private XmlAttribute[] anyAttrField;

        [XmlElementAttribute(Order = 0)]
        public System.Guid AuthenticationID
        {
            get { return this.authenticationIDField; }
            set
            {
                this.authenticationIDField = value;
                this.RaisePropertyChanged("AuthenticationID");
            }
        }

        [XmlElementAttribute(Order = 1)]
        public string ContactEmail
        {
            get { return this.contactEmailField; }
            set
            {
                this.contactEmailField = value;
                this.RaisePropertyChanged("ContactEmail");
            }
        }

        [XmlElementAttribute(Order = 2)]
        public string ContactPhone
        {
            get { return this.contactPhoneField; }
            set
            {
                this.contactPhoneField = value;
                this.RaisePropertyChanged("ContactPhone");
            }
        }

        [XmlElementAttribute(IsNullable = true, Order = 3)]
        public Nullable<DateTime> DateCreated
        {
            get { return this.dateCreatedField; }
            set
            {
                this.dateCreatedField = value;
                this.RaisePropertyChanged("DateCreated");
            }
        }

        [XmlElementAttribute(IsNullable = true, Order = 4)]
        public Nullable<DateTime> DateInactive
        {
            get { return this.dateInactiveField; }
            set
            {
                this.dateInactiveField = value;
                this.RaisePropertyChanged("DateInactive");
            }
        }

        [XmlElementAttribute(IsNullable = true, Order = 5)]
        public Nullable<DateTime> DateModified
        {
            get { return this.dateModifiedField; }
            set
            {
                this.dateModifiedField = value;
                this.RaisePropertyChanged("DateModified");
            }
        }

        [XmlElementAttribute(Order = 6)]
        public bool Inactive
        {
            get { return this.inactiveField; }
            set
            {
                this.inactiveField = value;
                this.RaisePropertyChanged("Inactive");
            }
        }

        [XmlElementAttribute(Order = 7)]
        public string TeamContact
        {
            get { return this.teamContactField; }
            set
            {
                this.teamContactField = value;
                this.RaisePropertyChanged("TeamContact");
            }
        }

        [XmlElementAttribute(Order = 8)]
        public string TeamName
        {
            get { return this.teamNameField; }
            set
            {
                this.teamNameField = value;
                this.RaisePropertyChanged("TeamName");
            }
        }

        [XmlAnyAttributeAttribute()]
        public XmlAttribute[] AnyAttr
        {
            get { return this.anyAttrField; }
            set
            {
                this.anyAttrField = value;
                this.RaisePropertyChanged("AnyAttr");
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void RaisePropertyChanged(string propertyName)
        {
            PropertyChangedEventHandler propertyChanged = this.PropertyChanged;
            if ((propertyChanged != null))
            {
                propertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }

    [GeneratedCodeAttribute("System.Xml", "4.0.30319.233")]
    [SerializableAttribute()]
    [DebuggerStepThroughAttribute()]
    [DesignerCategoryAttribute("code")]
    [XmlTypeAttribute(Namespace = "http://NumiExchange/")]
    public partial class ExchangeLevelOfCare : object, INotifyPropertyChanged
    {
        private string siteCodeField;
        private string patientSsnField;
        private Nullable<byte> levelOfCareField;
        private Nullable<DateTime> assignmentDateField;

        [XmlElementAttribute(Order = 0)]
        public string SiteCode
        {
            get { return this.siteCodeField; }
            set
            {
                this.siteCodeField = value;
                this.RaisePropertyChanged("SiteCode");
            }
        }

        [XmlElementAttribute(Order = 1)]
        public string PatientSsn
        {
            get { return this.patientSsnField; }
            set
            {
                this.patientSsnField = value;
                this.RaisePropertyChanged("PatientSsn");
            }
        }

        [XmlElementAttribute(IsNullable = true, Order = 2)]
        public System.Nullable<byte> LevelOfCare
        {
            get { return this.levelOfCareField; }
            set
            {
                this.levelOfCareField = value;
                this.RaisePropertyChanged("LevelOfCare");
            }
        }

        [XmlElementAttribute(IsNullable = true, Order = 3)]
        public Nullable<DateTime> AssignmentDate
        {
            get { return this.assignmentDateField; }
            set
            {
                this.assignmentDateField = value;
                this.RaisePropertyChanged("AssignmentDate");
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void RaisePropertyChanged(string propertyName)
        {
            PropertyChangedEventHandler propertyChanged = this.PropertyChanged;
            if ((propertyChanged != null))
            {
                propertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }

    [GeneratedCodeAttribute("System.Xml", "4.0.30319.233")]
    [SerializableAttribute()]
    [DebuggerStepThroughAttribute()]
    [DesignerCategoryAttribute("code")]
    [XmlTypeAttribute(Namespace = "http://NumiExchange/")]
    public partial class ExchangeItem : object, INotifyPropertyChanged
    {
        private string messageField;
        private ExchangeLevelOfCare[] levelOfCareArrayField;

        [XmlElementAttribute(Order = 0)]
        public string Message
        {
            get { return this.messageField; }
            set
            {
                this.messageField = value;
                this.RaisePropertyChanged("Message");
            }
        }

        [XmlArrayAttribute(Order = 1)]
        public ExchangeLevelOfCare[] LevelOfCareArray
        {
            get { return this.levelOfCareArrayField; }
            set
            {
                this.levelOfCareArrayField = value;
                this.RaisePropertyChanged("LevelOfCareArray");
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        protected void RaisePropertyChanged(string propertyName)
        {
            PropertyChangedEventHandler propertyChanged = this.PropertyChanged;
            if ((propertyChanged != null))
            {
                propertyChanged(this, new PropertyChangedEventArgs(propertyName));
            }
        }
    }

    [DebuggerStepThroughAttribute()]
    [GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
    [MessageContractAttribute(WrapperName = "GetLevelOfCareBySite", WrapperNamespace = "http://NumiExchange/", IsWrapped = true)]
    public partial class GetLevelOfCareBySiteRequest
    {
        [MessageHeaderAttribute(Namespace = "http://NumiExchange/")]
        public ExchangeAuthentication ExchangeAuthentication;

        [MessageBodyMemberAttribute(Namespace = "http://NumiExchange/", Order = 0)]
        public string SiteCode;

        public GetLevelOfCareBySiteRequest()
        {
        }

        public GetLevelOfCareBySiteRequest(ExchangeAuthentication ExchangeAuthentication, string SiteCode)
        {
            this.ExchangeAuthentication = ExchangeAuthentication;
            this.SiteCode = SiteCode;
        }
    }

    [DebuggerStepThroughAttribute()]
    [GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
    [MessageContractAttribute(WrapperName = "GetLevelOfCareBySiteResponse", WrapperNamespace = "http://NumiExchange/", IsWrapped = true)]
    public partial class GetLevelOfCareBySiteResponse
    {
        [MessageBodyMemberAttribute(Namespace = "http://NumiExchange/", Order = 0)]
        public ExchangeItem GetLevelOfCareBySiteResult;

        public GetLevelOfCareBySiteResponse()
        {
        }

        public GetLevelOfCareBySiteResponse(ExchangeItem GetLevelOfCareBySiteResult)
        {
            this.GetLevelOfCareBySiteResult = GetLevelOfCareBySiteResult;
        }
    }

    [GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public interface InpatientSoapChannel : InpatientSoap, IClientChannel
    {
    }

    [System.Diagnostics.DebuggerStepThroughAttribute()]
    [GeneratedCodeAttribute("System.ServiceModel", "4.0.0.0")]
    public partial class InpatientSoapClient : ClientBase<InpatientSoap>, InpatientSoap, IDisposable
    {
        #region ProxyTool Generated Code

        private InpatientSoapClient _instance;
        private string _endpointConfigurationName;
        private string _remoteAddress;
        private System.ServiceModel.EndpointAddress _endpointAddress;
        private System.ServiceModel.Channels.Binding _binding;

        private void InitProxyInstance()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        if (_instance.State != System.ServiceModel.CommunicationState.Faulted)
                            _instance.Close();
                        else
                            _instance.Abort();
                }
                catch { }

                if (_binding != null)
                    _instance = new InpatientSoapClient(_binding, _endpointAddress);
                else if (_endpointAddress != null)
                    _instance = new InpatientSoapClient(_endpointConfigurationName, _endpointAddress);
                else if (_remoteAddress != null)
                    _instance = new InpatientSoapClient(_endpointConfigurationName, _remoteAddress);
                else if (_endpointConfigurationName != null)
                    _instance = new InpatientSoapClient(_endpointConfigurationName);
                else
                    _instance = new InpatientSoapClient();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        void System.IDisposable.Dispose()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.Close();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Close()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<InpatientSoap>)_instance).Close();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<InpatientSoap>)this).Close();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public new void Abort()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    if (_instance != null)
                        ((System.ServiceModel.ClientBase<InpatientSoap>)_instance).Abort();
                    if (_instance != this)
                        ((System.ServiceModel.ClientBase<InpatientSoap>)this).Abort();
                }
                catch { }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion

        public InpatientSoapClient()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InpatientSoapClient(string endpointConfigurationName) : base(endpointConfigurationName)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InpatientSoapClient(string endpointConfigurationName, string remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _remoteAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InpatientSoapClient(string endpointConfigurationName, EndpointAddress remoteAddress) : base(endpointConfigurationName, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _endpointConfigurationName = endpointConfigurationName;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public InpatientSoapClient(Binding binding, EndpointAddress remoteAddress) : base(binding, remoteAddress)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                _instance = this;
                _binding = binding;
                _endpointAddress = remoteAddress;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [EditorBrowsableAttribute(EditorBrowsableState.Advanced)]
        GetLevelOfCareBySiteResponse InpatientSoap.GetLevelOfCareBySite(GetLevelOfCareBySiteRequest request)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                try
                {
                    return _instance.Channel.GetLevelOfCareBySite(request);
                }
                catch (System.Exception e)
                {
                    if (!ProxyManager.CheckThrownException(e))
                        throw;
                    else
                    {
                        InitProxyInstance();
                        return _instance.Channel.GetLevelOfCareBySite(request);
                    }
                }
                finally
                {
                    ProxyManager.ReturnProxy<InpatientSoapClient>(_instance, _endpointConfigurationName);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public ExchangeItem GetLevelOfCareBySite(ExchangeAuthentication ExchangeAuthentication, string SiteCode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                GetLevelOfCareBySiteRequest inValue = new GetLevelOfCareBySiteRequest();
                inValue.ExchangeAuthentication = ExchangeAuthentication;
                inValue.SiteCode = SiteCode;
                GetLevelOfCareBySiteResponse retVal = ((InpatientSoap)(this)).GetLevelOfCareBySite(inValue);
                return retVal.GetLevelOfCareBySiteResult;
            }            
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }        
    }
}
