﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.EVS;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.Threading;
using BMS.Utils;

namespace BMS.ServicesWrapper
{
    public class EIS_EVSLockWrapper
    {
        private static Dictionary<string, object> _eisSyncLocks = new Dictionary<string, object>();
        private static Dictionary<string, object> _evsSyncLocks = new Dictionary<string, object>();

        #region EIS

        public static void InsertBed(Bed obj, string vistaCode)
        {
            string key = vistaCode + "_bed";
            if (!_eisSyncLocks.ContainsKey(key))
                _eisSyncLocks.Add(key, new object());
            lock (_eisSyncLocks[key])
            {
                try
                {
                    Bed a = EISFactory.InstanceWindows.GetBed(obj.Ien, obj.VistaSite.Id);
                    if (a == null)
                        EISFactory.InstanceWindows.CreateBed(obj);
                    else
                        obj.Id = a.Id;
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertWard(Ward obj, string vistaCode)
        {
            string key = vistaCode + "_ward";
            if (!_eisSyncLocks.ContainsKey(key))
                _eisSyncLocks.Add(key, new object());
            lock (_eisSyncLocks[key])
            {
                try
                {
                    Ward a = EISFactory.InstanceWindows.GetWard(obj.Ien, obj.VistaSite.Id);
                    if (a == null)
                        EISFactory.InstanceWindows.CreateWard(obj);
                    else
                        obj.Id = a.Id;
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertHospitalLocation(HospitalLocation obj, string vistaCode)
        {
            string key = vistaCode + "_hospital";
            if (!_eisSyncLocks.ContainsKey(key))
                _eisSyncLocks.Add(key, new object());
            lock (_eisSyncLocks[key])
            {
                try
                {
                    HospitalLocation a = EISFactory.InstanceWindows.GetHospitalLocation(obj.Ien, obj.VistaSite.Id);
                    if (a == null)
                        EISFactory.InstanceWindows.CreateHospitalLocation(obj);
                    else
                        obj.Id = a.Id;
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertPatient(Patient obj, string vistaCode)
        {
            string key = "patient";
            if (!_eisSyncLocks.ContainsKey(key))
                _eisSyncLocks.Add(key, new object());
            lock (_eisSyncLocks[key])
            {
                try
                {
                    Patient a = EISFactory.InstanceWindows.GetPatientBySsn(obj.SSN, null);
                    if (a == null)
                        EISFactory.InstanceWindows.CreatePatient(obj);
                    else
                    {
                        II ien = obj.IENList.Where(ii => ii.root.Equals(vistaCode, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                        if (!CheckPatientIen(a, ien))
                        {
                            if (a.IENList == null)
                                a.IENList = new List<II>();
                            a.IENList.Add(ien);
                            EISFactory.InstanceWindows.UpdatePatient(a);
                        }
                        obj.Id = a.Id;
                    }
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertMedicalPerson(Person obj, string vistaCode)
        {
            string key = vistaCode + "_person";
            if (!_eisSyncLocks.ContainsKey(key))
                _eisSyncLocks.Add(key, new object());
            lock (_eisSyncLocks[key])
            {
                try
                {
                    Person a = EISFactory.InstanceWindows.GetMedicalPerson(obj.Ien, obj.VistaSite);
                    if (a == null)
                        EISFactory.InstanceWindows.CreateMedicalPerson(obj);
                    else
                        obj.Id = a.Id;
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        private static bool CheckPatientIen(Patient patient, II ien)
        {
            if (patient.IENList == null)
                return false;
            if (patient.IENList != null && patient.IENList.Count == 0)
                return false;
            if (patient.IENList != null && patient.IENList.Count > 0)
            {
                if (patient.IENList.Where(ii => ii.root.Equals(ien.root, StringComparison.InvariantCultureIgnoreCase) && ii.extension.Equals(ien.extension)).FirstOrDefault() != null)
                    return true;
            }
            return false;
        }

        #endregion

        #region EVS

        public static void InsertOrderableItem(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    if (!EVSFactory.InstanceWindows.ConceptCodeExists(obj.code, obj.codeSystem))
                        EVSFactory.InstanceWindows.InsertConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertSpecialty(CD obj, string vistaCode)
        {
            string key = obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    if (!EVSFactory.InstanceWindows.ConceptCodeExists(obj.code, obj.codeSystem))
                        EVSFactory.InstanceWindows.InsertConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertTreatingSpecialty(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    if (!EVSFactory.InstanceWindows.ConceptCodeExists(obj.code, obj.codeSystem))
                        EVSFactory.InstanceWindows.InsertConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertFacilityMovementType(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    if (!EVSFactory.InstanceWindows.ConceptCodeExists(obj.code, obj.codeSystem))
                        EVSFactory.InstanceWindows.InsertConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void InsertMedicalCenterDivision(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    if (!EVSFactory.InstanceWindows.ConceptCodeExists(obj.code, obj.codeSystem))
                        EVSFactory.InstanceWindows.InsertConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void UpdateOrderableItem(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    EVSFactory.InstanceWindows.UpdateConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void UpdateSpecialty(CD obj, string vistaCode)
        {
            string key = obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    EVSFactory.InstanceWindows.UpdateConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void UpdateTreatingSpecialty(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    EVSFactory.InstanceWindows.UpdateConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void UpdateFacilityMovementType(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    EVSFactory.InstanceWindows.UpdateConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        public static void UpdateMedicalCenterDivision(CD obj, string vistaCode)
        {
            string key = vistaCode + "_" + obj.codeSystemName;
            if (!_evsSyncLocks.ContainsKey(key))
                _evsSyncLocks.Add(key, new object());
            lock (_evsSyncLocks[key])
            {
                try
                {
                    EVSFactory.InstanceWindows.UpdateConcept(obj);
                }
                catch (Exception ex)
                {
                    Tracer.TraceException(ex);
                }
            }
        }

        #endregion
    }
}
