﻿using System;
using System.Activities;
using InfoWorld.HL7.ITS;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.Facade.Translators;
using BMS.ServicesWrapper.BMService;

namespace BMS.Workflows.CustomActivities
{
    public class CreateWaitingListItem : CodeActivity
    {
        public InArgument<FC.WaitingListItem> WaitingListItem { get; set; }
        public OutArgument<II> WaitingListItemId { get; set; }
        public OutArgument<Guid> WorkflowId { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FC.WaitingListItem facadeItem = this.WaitingListItem.Get<FC.WaitingListItem>(context);
                SC.WaitingListItem waitingListItem = facadeItem.ToDataContract();

                if (facadeItem.UndoRemovalOfPreviousItem && (facadeItem.FlowId == null || facadeItem.FlowId == Guid.Empty || facadeItem.Id == null || string.IsNullOrEmpty(facadeItem.Id.extension)))
                    throw new Exception("Undo WL removal with insufficient information.");

                if (waitingListItem.FlowId == null || waitingListItem.FlowId == Guid.Empty)
                    waitingListItem.FlowId = context.WorkflowInstanceId;

                II waitingListItemId = null;
                if (facadeItem.UndoRemovalOfPreviousItem)
                {
                    waitingListItem.RemovedDate = null;
                    BMSFactory.BedManagerOperationsClientFromWCF.UpdateWaitingListItem(waitingListItem);
                    waitingListItemId = waitingListItem.Id;
                }
                else
                    waitingListItemId = BMSFactory.BedManagerOperationsClientFromWCF.CreateWaitingListItem(waitingListItem);
                this.WaitingListItemId.Set(context, waitingListItemId);
                this.WorkflowId.Set(context, waitingListItem.FlowId);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
