﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using FC = BMS.Facade.Data;
using SC = BMS.DataContracts;
using BMS.ServicesWrapper.BMService;
using InfoWorld.HL7.ITS;
using BMS.Facade.Translators;

namespace BMS.Workflows.CustomActivities
{
    public class CreateBedUnavailableEvent : CodeActivity
    {
        public InArgument<FC.BedUnavailable> BedUnavailable { get; set; }
        public OutArgument<II> BedUnavailableId { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SC.BedUnavailable bedUnavailable = this.BedUnavailable.Get<FC.BedUnavailable>(context).ToDataContract();
                bedUnavailable.FlowId = context.WorkflowInstanceId;
                II bedUnavailableId = BMSFactory.BedManagerOperationsClientFromWCF.CreateBedUnavailable(bedUnavailable);
                this.BedUnavailableId.Set(context, bedUnavailableId);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
