﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.ServiceModel.Activities.Configuration;
using System.ServiceModel.Activities.Description;
using System.Text;

namespace BMS.Workflows.PropertyPromotionActivity.Configuration
{
    class SqlWorkflowInstanceStorePromotionElement : SqlWorkflowInstanceStoreElement
    {
        public override Type BehaviorType
        {
            get { return typeof(SqlWorkflowInstanceStorePromotionBehavior); }
        }

        [ConfigurationProperty("promotionSets", IsDefaultCollection = false)]
        public PromotionSetsCollection PromotionSets
        {
            get
            {
                DateTime entryInLogMethodTime = DateTime.UtcNow;
                if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
                }
                try
                {
                    return (PromotionSetsCollection)base["promotionSets"];
                }
                finally
                {
                    if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                    {
                        InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                    }
                }
            }
        }

        protected override object CreateBehavior()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SqlWorkflowInstanceStorePromotionBehavior behavior = new SqlWorkflowInstanceStorePromotionBehavior((SqlWorkflowInstanceStoreBehavior)base.CreateBehavior());

                foreach (PromotionSet promotionSet in this.PromotionSets)
                {
                    List<string> sqlVariantProperties = new List<string>();
                    List<string> binaryProperties = new List<string>();

                    foreach (PromotedValueElement promotedValue in promotionSet)
                    {
                        (promotedValue.IsSqlVariant ? sqlVariantProperties : binaryProperties).Add(promotedValue.PropertyName);
                    }

                    behavior.Promote(promotionSet.Name, sqlVariantProperties, binaryProperties);
                }

                return behavior;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
