﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.Facade.Data;
using BMS.VistaWorker2.Writer.Implementation.Concrete.Dal;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached
{
    public class EvsCachedDal : BaseCachedDal<CD>
    {
        private readonly string codeSystemName;

        public EvsCachedDal(EvsDal dal)
            : base(dal)
        {
            this.codeSystemName = dal.CodeSystemName;
        }

        private string GetIen(CD concept)
        {
            return WriterUtilities.GetIen(Site.Code, concept);
        }

        private bool ValidForCache(CD cd)
        {
            return WriterUtilities.VistAEqual(Site.Code, cd);
        }

        protected override Dictionary<string, CD> InitCache()
        {
            IList<CD> cds = null;
            if (codeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
            {
                cds = EVS.SearchConceptsWithPaging(new CodeFilterParameters()
                {
                    VocabularyDomain = codeSystemName,
                    MaxSelectedCodes = int.MaxValue,
                    MatchAlgorithm = MatchAlgorithm.StartsWithIgnoreCase,
                    MatchProperty = MatchProperty.Code,
                    MatchText = Site.Code
                }).Where(ValidForCache).ToList();
            }
            else
                cds = EVS.GetCodes(new CodeFilterParameters() { VocabularyDomain = codeSystemName, MaxSelectedCodes = int.MaxValue }).Where(ValidForCache).ToList();

            Dictionary<string, CD> result = new Dictionary<string, CD>();
            string ien = null;
            foreach (CD cd in cds)
            {
                ien = GetIen(cd);
                if (result.ContainsKey(ien))
                    result[ien] = cd;
                else
                    result.Add(ien, cd);
            }
            return result;
        }
    }
}
