﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper.BMService;
using BMS.VistaWorker2.Writer.Implementation.Concrete.Dal;
using BMS.VistaIntegration.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached
{
    public class BedCachedDal : BaseCachedDal<Bed>
    {
        public BedCachedDal(IEntityDal<Bed> dal) : base(dal) { }

        protected override Dictionary<string, Bed> InitCache()
        {            
            var cache = new Dictionary<string, Bed>();
            List<Bed> beds = EIS.GetBedsByVista(Site.Id);
            if (beds != null)
            {
                foreach (var bed in beds)
                    cache[bed.Ien] = bed;
            }
            return cache;
        }
    }
}
