﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.ServicesWrapper;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class NewPersonDal : BaseDal<Person>
    {
        public NewPersonDal(VistaSite site) : base(site) { }

        public override Person Get(VistaIntegration.Data.IEntity vistaEntity)
        {
            return EIS.GetMedicalPerson(vistaEntity.IEN, Site.Id);
        }

        public override void Add(VistaIntegration.Data.IEntity vistaEntity, Person entity)
        {
            EIS_EVSLockWrapper.InsertMedicalPerson(entity, Site.Code);
        }

        public override void Delete(VistaIntegration.Data.IEntity vistaEntity, Person entity)
        {
            EIS.DeleteMedicalPerson(entity.Id);
        }

        public override void Update(VistaIntegration.Data.IEntity vistaEntity, Person entity)
        {
            EIS.UpdateMedicalPerson(entity);
        }
    }
}
