﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper;
using BMS.ServicesWrapper.EVS;
using BMS.Facade.Data;
using BMS.VistaIntegration.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class EvsDal : BaseDal<CD>
    {
        public string CodeSystemName { get; private set; }

        public EvsDal(VistaSite site, string codeSystemName)
            : base(site)
        {
            this.CodeSystemName = codeSystemName;
        }

        private string GetIen(CD concept)
        {
            return WriterUtilities.GetIen(Site.Code, concept);
        }

        private bool ValidForCache(CD cd)
        {
            return WriterUtilities.VistAEqual(Site.Code, cd);
        }


        public override CD Get(IEntity vistaEntity)
        {
            string ien = vistaEntity.IEN;
            IList<CD> cds = null;
            if (CodeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
            {
                cds = EVS.SearchConceptsWithPaging(new CodeFilterParameters()
                {
                    VocabularyDomain = CodeSystemName,
                    MaxSelectedCodes = int.MaxValue,
                    MatchAlgorithm = MatchAlgorithm.StartsWithIgnoreCase,
                    MatchProperty = MatchProperty.Code,
                    MatchText = Site.Code
                });
            }
            else
                cds = EVS.GetCodes(new CodeFilterParameters() { VocabularyDomain = CodeSystemName, MaxSelectedCodes = int.MaxValue });
            return cds.FirstOrDefault(cd => ValidForCache(cd) & GetIen(cd) == ien);
        }

        public override void Add(IEntity vistaEntity, CD entity)
        {
            if (entity.codeSystemName.Equals(Util.Vocabulary.VistaMedicalCenterDivision.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertMedicalCenterDivision(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertOrderableItem(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaTreatingSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertTreatingSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.TypeOfMovement.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.InsertFacilityMovementType(entity, Site.Code);
        }

        public override void Delete(IEntity vistaEntity, CD entity)
        {
            EVS.DeleteConcept(entity);
        }

        public override void Update(IEntity vistaEntity, CD entity)
        {
            if (entity.codeSystemName.Equals(Util.Vocabulary.VistaMedicalCenterDivision.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateMedicalCenterDivision(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.OrderableItem.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateOrderableItem(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.VistaTreatingSpecialty.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateTreatingSpecialty(entity, Site.Code);
            else if (entity.codeSystemName.Equals(Util.Vocabulary.TypeOfMovement.ToString(), StringComparison.InvariantCultureIgnoreCase))
                EIS_EVSLockWrapper.UpdateFacilityMovementType(entity, Site.Code);            
        }
    }
}
