﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper;
using BMS.VistaIntegration.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public class BedDal : BaseDal<Bed>
    {
        public BedDal(VistaSite site) : base(site)
        {
        }

        public override Bed Get(IEntity vistaEntity)
        {
            return EIS.GetBed(vistaEntity.IEN, Site.Id);
        }

        public override void Add(IEntity vistaEntity, Bed entity)
        {
            EIS_EVSLockWrapper.InsertBed(entity, Site.Code);
        }

        public override void Delete(IEntity vistaEntity, Bed entity)
        {
            EIS.DeleteBed(entity.Id);
        }

        public override void Update(IEntity vistaEntity, Bed entity)
        {
            EIS.UpdateBed(entity);
        }
    }
}
