﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Writer.Concrete;
using BMS.Facade.Data;
using BMS.ServicesWrapper.EIS;
using System.Configuration;
using BMS.ServicesWrapper.Security;

namespace BMS.VistaWorker.Writer
{
    /// <summary>
    /// Writer manager factory - creates an underlying writer manager.
    /// </summary>
    public static class WriterManagerFactory
    {
        /// <summary>
        /// Creates the writer manager.
        /// </summary>
        /// <returns></returns>
        public static IWriterManager MakeWriterManager(string vistACode)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return new WriterManager(vistACode);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
