﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Writer.Concrete.EIS;
using BMS.VistaWorker.Writer.Concrete.EVS;
using BMS.VistaWorker.Writer.Concrete.WF;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Writer.Abstract;
using BMS.Facade.Data;

namespace BMS.VistaWorker.Writer.Concrete
{
    /// <summary>
    /// The writer manager implementation.
    /// </summary>
    public class WriterManager : BaseWriterManager
    {

        public WriterManager(string vistACode)
            : base(vistACode)
        {
        }

        protected override void CreateEntityWriters()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                CreateWritersForEis();
                CreateWritersForEvs();
                CreateWritersForWorkFlow();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void CreateWritersForEis()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Add(new HospitalLocationWriter());
                Add(new RoomBedWriter());
                Add(new WardLocationWriter());
                Add(new PatientWriter());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void CreateWritersForEvs()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Add(new OrderableItemWriter());
                Add(new SpecialtyWriter());
                Add(new TreatingSpecialtyWriter());
                Add(new TypeOfMovementWriter());
                Add(new MedicalCenterDivisionWriter());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void CreateWritersForWorkFlow()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                Add(new OrderWriter());
                Add(new PatientAppointmentWriter());
                Add(new PatientMovementWriter());
                Add(new ScheduledAdmissionWriter());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
