﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista scheduled admission entity.
    /// </summary>
    [Serializable]
    public class ScheduledAdmission : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the patient id (IEN).
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the reservation date time.
        /// </summary>
        /// <value>
        /// The reservation date time.
        /// </value>
        public DateTime? ReservationDateTime { get; set; }

        /// <summary>
        /// Gets or sets the length of stay expected.
        /// </summary>
        /// <value>
        /// The length of stay expected.
        /// </value>
        public int? LengthOfStayExpected { get; set; }

        /// <summary>
        /// Gets or sets the admitting diagnosis.
        /// </summary>
        /// <value>
        /// The admitting diagnosis.
        /// </value>
        public string AdmittingDiagnosis { get; set; }

        /// <summary>
        /// Gets or sets the new name of the person.
        /// </summary>
        /// <value>
        /// The new name of the person.
        /// </value>
        public string SchedulerName { get; set; }

        /// <summary>
        /// Gets or sets the surgery.
        /// </summary>
        /// <value>
        /// The surgery.
        /// </value>
        public string Surgery { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public string WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the treating specialty id.
        /// </summary>
        /// <value>
        /// The treating specialty id.
        /// </value>
        public int? TreatingSpecialtyId { get; set; }

        /// <summary>
        /// Gets or sets the ward or treating specialty.
        /// </summary>
        /// <value>
        /// The ward or treating specialty.
        /// </value>
        public string WardOrTreatingSpecialty { get; set; }

        /// <summary>
        /// Gets or sets the new person id.
        /// </summary>
        /// <value>
        /// The new person id.
        /// </value>
        public int? SchedulerId { get; set; }

        /// <summary>
        /// Gets or sets the medical center division id.
        /// </summary>
        /// <value>
        /// The medical center division id.
        /// </value>
        public int? MedicalCenterDivisionId { get; set; }

        /// <summary>
        /// Gets or sets the name of the medical center division.
        /// </summary>
        /// <value>
        /// The name of the medical center division.
        /// </value>
        public string MedicalCenterDivisionName { get; set; }

        /// <summary>
        /// Gets or sets the date time cancelled.
        /// </summary>
        /// <value>
        /// The date time cancelled.
        /// </value>
        public DateTime? DateTimeCancelled { get; set; }

        /// <summary>
        /// Gets or sets the patient movement id.
        /// </summary>
        /// <value>
        /// The patient movement id.
        /// </value>
        public int? PatientMovementId { get; set; }


        /// <summary>
        /// Gets or sets the new person.
        /// </summary>
        /// <value>
        /// The new person.
        /// </value>
        public NewPerson Scheduler { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider.
        /// </summary>
        /// <value>
        /// The provider.
        /// </value>
        public NewPerson Provider { get; set; }

        /// <summary>
        /// Gets or sets the medical center division.
        /// </summary>
        /// <value>
        /// The medical center division.
        /// </value>
        public MedicalCenterDivision MedicalCenterDivision { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        public Patient Patient { get; set; }
    }
}
