﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista patient movement entity.
    /// </summary>
    [Serializable]
    public class PatientMovement : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the date time.
        /// </summary>
        /// <value>
        /// The date time.
        /// </value>
        public DateTime DateTime { get; set; }

        /// <summary>
        /// Gets or sets the entered on date time.
        /// </summary>
        /// <value>
        /// The entered on date time.
        /// </value>
        public DateTime EnteredOnDateTime { get; set; }

        /// <summary>
        /// Gets or sets the entered by id.
        /// </summary>
        /// <value>
        /// The entered by id.
        /// </value>
        public string EnteredById { get; set; }

        /// <summary>
        /// Gets or sets the entered by.
        /// </summary>
        /// <value>
        /// The entered by.
        /// </value>
        public NewPerson EnteredBy { get; set; }

        /// <summary>
        /// Gets or sets the transaction id.
        /// </summary>
        /// <value>
        /// The transaction id.
        /// </value>
        public int? TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the name of the mas movement trans.
        /// </summary>
        /// <value>
        /// The name of the mas movement trans.
        /// </value>
        public string MasMovementTransName { get; set; }

        /// <summary>
        /// Gets or sets the patient id (IEN).
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public string PatientId { get; set; }

        /// <summary>
        /// Gets or sets the type of movement id.
        /// </summary>
        /// <value>
        /// The type of movement id.
        /// </value>
        public int? TypeOfMovementId { get; set; }

        /// <summary>
        /// Gets or sets the name of the fac move type.
        /// </summary>
        /// <value>
        /// The name of the fac move type.
        /// </value>
        public string FacMoveTypeName { get; set; }

        /// <summary>
        /// Gets or sets the ward location id (IEN).
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public string WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the room bed id (IEN).
        /// </summary>
        /// <value>
        /// The room bed id.
        /// </value>
        public string RoomBedId { get; set; }

        /// <summary>
        /// Gets or sets the admission check in movement id.
        /// </summary>
        /// <value>
        /// The admission check in movement id.
        /// </value>
        public int? AdmissionCheckInMovementId { get; set; }

        /// <summary>
        /// Gets or sets the related physical movement id.
        /// </summary>
        /// <value>
        /// The related physical movement id.
        /// </value>
        public int? RelatedPhysicalMovementId { get; set; }

        /// <summary>
        /// Gets or sets the ward at discharge.
        /// </summary>
        /// <value>
        /// The ward at discharge.
        /// </value>
        public string WardAtDischarge { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        /// <value>
        /// The transaction.
        /// </value>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the patient.
        /// </summary>
        /// <value>
        /// The patient.
        /// </value>
        public Patient Patient { get; set; }



    }
}
