﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista orders order actions entity.
    /// </summary>
    [Serializable]
    public class OrdersOrderActions : IEntity
    {
        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public int OrderId{get;set;}
        /// <summary>
        /// Gets or sets the order action id.
        /// </summary>
        /// <value>
        /// The order action id.
        /// </value>
        public int OrderActionId { get; set; }

        /// <summary>
        /// Inserts the entity.
        /// </summary>
        /// <param name="writerManager">The writer manager.</param>
        public void Insert(IWriterManager writerManager)
        {
            writerManager.OrdersOrderActionsWriter.Insert(this);
        }

        /// <summary>
        /// Updates the entity.
        /// </summary>
        /// <param name="writerManager">The writer manager.</param>
        public void Update(IWriterManager writerManager)
        {
            writerManager.OrdersOrderActionsWriter.Update(this);
        }

        /// <summary>
        /// Deletes the entity.
        /// </summary>
        /// <param name="writerManager">The writer manager.</param>
        public void Delete(IWriterManager writerManager)
        {
            writerManager.OrdersOrderActionsWriter.Delete(this);
        }
    }
}
